#include <time.h>

#include <iostream>
#include <fstream>

#include "OptionHandler.hh"

#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>

#include "CaliceMaps1TestSystemInterface.hh"
#include "BunchTrainBuffer.hh"


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;

  try{

    int lReset=-1;

    if(argc==2){
      istringstream(argv[1])>>lReset;
    }

    if(lReset<0){
      std::cout<<"Resetting all boards"<<std::endl;
    }else{
      std::cout<<"Resetting board "<<lReset<<std::endl;
    }    
    
    CaliceMaps1TestSystemInterface * lSys[4];
    
    int lCount=CaliceMaps1TestSystemInterface::Instance(lSys);
    
    cout<<"============================================"<<endl;
    if(lCount==1){
      cout<<"there was "<<lCount<<" DAQ system detected"<<endl;
    }else{
      cout<<"there were "<<lCount<<" DAQ systems detected"<<endl;
    }
    cout<<"============================================"<<endl;
    
    for(int i=0; i<lCount; i++){
      if(lSys[i]->IsMaster()){
	cout<<"number "<<i<<" is the master."<<endl;
      }else{
	cout<<"number "<<i<<" is a slave."<<endl;
      }
    }
    
    cout<<"-------------------------------"<<endl;
    if(lReset>=(lCount)){
     
      cout<<"board "<<lReset<<" doesn't exist."<<endl;
      
    }
    
      
    for(int i=0; i<lCount; i++){
      if(lReset<0){
	cout<<"Resetting "<<i<<endl;
	lSys[i]->LogicReset();
      }else{
	if(i==lReset){
	  cout<<"Resetting "<<i<<endl;
	  lSys[i]->LogicReset();
	}
      }

    }
    cout<<"-------------------------------"<<endl;
    
  }catch(USBDAQException & aExc){
    cout<<aExc<<endl;
  }
}
