#ifndef BunchTrainBuffer_HH_
#define BunchTrainBuffer_HH_

#include <iostream>

#include "TypeDefs.hh"




namespace CALICEMAPS1
{
  using namespace ::USBDAQ; 

  class PixelHit{
    friend class BunchTrainInterpreter;
  public: 
    PixelHit();
    
    u16 GetTimeCode()const;
    void SetTimeCode(u16 aTC);
    
    u16 GetRowAddress()const;
    void SetRowAddress(u16 aRowAddr);
    
    u16 GetColumnAddress()const;
    void SetColumnAddress(u16 aColAddr);
    
    u8 GetHitPattern()const;
    void SetHitPattern(u8 aHitPat);
    
    u8 GetMuxAddress()const;
    void SetMuxAddress(u8 aMuxAddr);
    
    void Reset();
    
    friend std::ostream & operator<<(std::ostream & aOs, 
				   const PixelHit & aPH);
  private:
    u16 mTimeCode;
    i16 mRowAddr;
    i16 mColAddr;
    u8 mHitPattern;
    u8 mMuxAddr;
  };

  std::ostream & operator<<(std::ostream & aOs, 
			    const PixelHit & aPH);
 
  
  class BunchTrainBuffer
  {
  public:
    friend class BunchTrainInterpreter;

    BunchTrainBuffer();
    BunchTrainBuffer(u32 aLen);
    virtual ~BunchTrainBuffer();
    
    BunchTrainBuffer(const BunchTrainBuffer & aBTBuf);
    BunchTrainBuffer & operator=(const BunchTrainBuffer & aRhs);
    
    void ResetBuffer(u32 aLen);
    
    u32 GetBufferLength();

    const u32 * GetBufferReference()const;
    u32 * GetBufferReference();
    u32 * ExtractBuffer();
        
    void SetColumnLength(u16 aCol, u16 aLen);
    bool IsGood()const;
    friend std::ostream & operator<<(std::ostream & aOs, 
				     const BunchTrainBuffer & aBTB);
  private:
    
    void AllocateBuffer(u32 aLen);
    
  private: 
    u32 * mBuf;
    u32 mLen;
    u16 mColLengths[4];
    bool mIsGood;
  };
  
  std::ostream & operator<<(std::ostream & aOs, 
			    const BunchTrainBuffer & aBTB);
  
  
  
  class BunchTrainInterpreter
  {
  public: 
    BunchTrainInterpreter();
    BunchTrainInterpreter(BunchTrainBuffer & aBTB);
    ~BunchTrainInterpreter();
        
    // BunchTrainInterpreter(const BunchTrainInterpreter &);
        
    void SetPixelHitBuffer(PixelHit * aPixHitBuf)const;

    // sets the internal counter to 0
    void Begin()const;
    
    // fills the reference and increments the internal pointer. 
    // returns true for valid hit, false for the end. 
    // usage: 
    // PixelHit lPH[6];
    // lBIT.SetPixelHitBuffer(lPH);
    // u16 lHitCount=0;
    // lBTI.Begin();
    // while((lHitCount=lBTI.GetNextPixelHit(lPH))){
    //    // user code
    // }
    //
    u16 GetNextPixelHitSet()const;
    
    void SetBuffer(BunchTrainBuffer & aBTB);
        
    u32 IntegrityCheck();
    
    friend std::ostream & operator<<(std::ostream & aOs, const BunchTrainInterpreter & aInt);

  private: 
    static const u16 * const GetMuxLUT();
  private:
    BunchTrainBuffer * mBuffer;
    mutable u32 mIndex;
    mutable u16 mCurQuad;
    mutable PixelHit * mHitBuf;
    
  };
  std::ostream & operator<<(std::ostream & aOs, const BunchTrainInterpreter & aInt);
  
}//~namespace CALICEMAPS1

#endif//~BunchTrainBuffer_HH_

