#ifndef OptionHandler_HH_
#define OptionHandler_HH_

#include <string>

class OptionHandler
{
public:

  OptionHandler(int aArgc, char ** aArgv);
  ~OptionHandler();
  
  enum RADIX{DEC, HEX};
  
  
  int GetOption(char aId, int & aVal, int aRadix=DEC)const;
  int GetOption(const std::string & aId, int & aVal, int aRadix=DEC)const;
  int GetOption(char aId, std::string & aVal)const;
  int GetOption(const std::string & aId, std::string & aVal)const;
  
  bool GetOption(char aId)const;
  bool GetOption(const std::string & aId)const;

private: 
  
  
  int Locate(char aId, std::string & aVal)const;
  int Locate(const std::string & aId, std::string & aVal)const;
  

private:
  OptionHandler();
  OptionHandler(const OptionHandler &);
  OptionHandler & operator=(const OptionHandler &);


private:
  int mArgc;
  char ** mArgv;
};

#endif
