#include "OptionHandler.hh"

#include "sstream"
#include <string.h>

OptionHandler::OptionHandler(int aArgc, char ** aArgv):
  mArgc(aArgc), 
  mArgv(aArgv)
{
  
}

OptionHandler::~OptionHandler()
{
  
}


int OptionHandler::GetOption(char aId, int & aVal, int aRadix)const
{
  std::string lTemp;
  int lRet=this->Locate(aId,lTemp);
  if(lRet==0){
    if(aRadix==DEC)
      std::istringstream(lTemp)>>aVal;

    if(aRadix==HEX)
      std::istringstream(lTemp)>>std::hex>>aVal;
    
  }
  return lRet;
}


int OptionHandler::GetOption(const std::string & aId, int & aVal, int aRadix)const
{
  std::string lTemp;
  int lRet=this->Locate(aId, lTemp);
  if(lRet==0){
    if(aRadix==DEC)
      std::istringstream(lTemp)>>aVal;

    if(aRadix==HEX)
      std::istringstream(lTemp)>>std::hex>>aVal;
  }
  return lRet;
}


int OptionHandler::GetOption(char aId, std::string & aVal)const
{
  return this->Locate(aId,aVal);
}


int OptionHandler::GetOption(const std::string & aId, std::string & aVal)const
{
  return this->Locate(aId, aVal);
}

bool OptionHandler::GetOption(char aId)const{
  for(int i=1; i<(mArgc); i++){
    if(mArgv[i][0]=='-'){
      if(mArgv[i][1]==aId){
	return true;
      }
    }
  }
  return false;
}

bool OptionHandler::GetOption(const std::string & aId)const{
  for(int i=1; i<(mArgc); i++){
    if(strncmp(mArgv[i], "--", 2)==0){
      if(strcmp(aId.c_str(), &mArgv[i][2])==0){
	return true;
      }
    }
  }
  return false;
}

  
int OptionHandler::Locate(char aId, std::string & aVal)const
{
  for(int i=1; i<(mArgc-1); i++){
    if(mArgv[i][0]=='-'){
      if(mArgv[i][1]==aId){
	aVal=mArgv[i+1];
	return 0;
      }
    }
  }

  return 1;
}

int OptionHandler::Locate(const std::string & aId, std::string & aVal)const
{
  for(int i=1; i<(mArgc-1); i++){
    if(strncmp(mArgv[i], "--", 2)==0){
      if(strcmp(aId.c_str(), &mArgv[i][2])==0){
	aVal=mArgv[i+1];
	return 0;
      }
    }
  }

  return 1;
}

