#include <iostream>
#include "USBDAQException.hh"
#include "TPACMasterController.hh"
#include <time.h>
#include <signal.h>

int gEnd=0;

void CtrlC(int aSig)
{
  std::cout<<"Ctrl-C trapped... setting flag..."<<std::endl;
  gEnd=1;

}




int main()
{
  using namespace std; 
  using namespace USBDAQ; 
  
  signal(SIGINT, CtrlC);

  try{
    
    TPACMasterController lTMC;
    char lTimeBuf[256];
    time_t lTime=lTMC.ReadFirmwareBuildTime();
    cout<<"Firmware build = "<<lTMC.ReadFirmwareVersion()<<endl;
    cout<<"Firmware build time = "<<lTime
	<<"\n                      "
	<<ctime_r(&lTime, lTimeBuf)<<endl;

  

    lTMC.SetResetLength(1000);
    lTMC.SetSpillCycleStart(1001);
    lTMC.SetBunchCrossingLength(16);
    lTMC.SetBunchTrainLength(8000);
    lTMC.SetTriggerEnableMask(0xaaaa);
    lTMC.SetTriggerInversionMask(0x5555);
    lTMC.SetTestTriggerStart(10001);
    lTMC.SetTestTriggerEnd(10011);

    // read back:
    
    cout<<dec<<"Reset Length = "<<lTMC.ReadResetLength()<<endl;
    cout<<"Spill Cycle Start = "<<lTMC.ReadSpillCycleStart()<<endl;
    cout<<"Bunch crossing length = "<<lTMC.ReadBunchCrossingLength()<<endl;
    cout<<"Bunch train length = "<<lTMC.ReadBunchTrainLength()<<endl;
    cout<<"Trigger enable mask = 0x"
	<<hex<<lTMC.ReadTriggerEnableMask()<<dec<<endl;

    cout<<"Trigger inversion mask = "
	<<hex<<lTMC.ReadTriggerInversionMask()<<dec<<endl;

    cout<<"Test trigger start = "
	<<lTMC.ReadTestTriggerStart()<<endl;

    cout<<"Test trigger end = "
	<<lTMC.ReadTestTriggerEnd()<<endl;
    
   
    u32 lTemp1In=0;
    u32 lTemp2In=0;
    u32 lTemp1Out=0;
    u32 lTemp2Out=0;

    u32 lCount=0;
    u32 lErr1=0;
    u32 lErr2=0;

    time_t lStart=time(0);
    time_t lEnd=0;
    
    
    do{
      lTemp1In=rand();
      lTemp2In=rand();
      
      lTMC.SetTestTriggerStart(lTemp1In);
      lTMC.SetTestTriggerEnd(lTemp2In);

      lTemp1Out=lTMC.ReadTestTriggerStart();
      lTemp2Out=lTMC.ReadTestTriggerEnd();

      if(lTemp1Out!=lTemp1In)
	lErr1++;
       
      if(lTemp2Out!=lTemp2In)
	lErr2++;
      
      lCount++;
      
      if((lCount%5000)==0){
	
	cout<<lCount<<" trials ~ "
	    <<(static_cast<double>(lCount)/(time(0)-lStart))
	    <<" per second.\n";
	cout<<"     "<<lErr1<<" errors (reg1)\n";
	cout<<"     "<<lErr2<<" errors (reg2)\n"<<endl;
      }

    }while(gEnd==0);

    cout<<lCount<<" trials \n";
    cout<<lErr1<<" reg 1 errors \n";
    cout<<lErr2<<" reg 2 errors \n"<<endl;
    
    lEnd=time(0);
    cout<<lCount<<" trials ~ "
	<<(static_cast<double>(lCount)/(lEnd-lStart))
	<<" per second.";

  }catch(USBDAQ::USBDAQException & aExc){
    cerr<<"USBDAQException caught: \n";
    cerr<<aExc.What();
    cerr<<"\n";
  }catch(std::exception & aExc){
    cerr<<"std::exception caught: \n";
    cerr<<aExc.what();
    cerr<<"\n";
  }catch(...){
    cerr<<"unknown exception caught.\n";
  }

  return 0;
}
