#include <iostream>
#include "USBDAQException.hh"
#include "TPACMasterController.hh"
#include <time.h>
#include <signal.h>

int gEnd=0;

void CtrlC(int aSig)
{
  std::cout<<"Ctrl-C trapped... setting flag..."<<std::endl;
  gEnd=1;
  
}

int main()
{
  using namespace std; 
  using namespace USBDAQ; 
  
  signal(SIGINT, CtrlC);
  

  try{
    
    TPACMasterController lTMC;
    char lTimeBuf[256];
    time_t lTime=lTMC.ReadFirmwareBuildTime();
    cout<<"Firmware build = "<<lTMC.ReadFirmwareVersion()<<endl;
    cout<<"Firmware build time = "<<lTime
	<<"\n                      "
	<<ctime_r(&lTime, lTimeBuf)<<endl;

  

    lTMC.SetResetLength(1000);
    lTMC.SetSpillCycleStart(1001);
    lTMC.SetBunchCrossingLength(16);
    lTMC.SetBunchTrainLength(8000);
    lTMC.SetTriggerEnableMask(0xaaaa);
    lTMC.SetTriggerInversionMask(0x5555);
    lTMC.SetTestTriggerStart(10001);
    lTMC.SetTestTriggerEnd(10011);

    // read back:
    
    cout<<dec<<"Reset Length = "<<lTMC.ReadResetLength()<<endl;
    cout<<"Spill Cycle Start = "<<lTMC.ReadSpillCycleStart()<<endl;
    cout<<"Bunch crossing length = "<<lTMC.ReadBunchCrossingLength()<<endl;
    cout<<"Bunch train length = "<<lTMC.ReadBunchTrainLength()<<endl;
    cout<<"Trigger enable mask = 0x"
	<<hex<<lTMC.ReadTriggerEnableMask()<<dec<<endl;

    cout<<"Trigger inversion mask = "
	<<hex<<lTMC.ReadTriggerInversionMask()<<dec<<endl;

    cout<<"Test trigger start = "
	<<lTMC.ReadTestTriggerStart()<<endl;

    cout<<"Test trigger end = "
	<<lTMC.ReadTestTriggerEnd()<<endl;
    
    cout<<"Status = 0x"<<hex<<lTMC.ReadStatus()<<dec<<endl;
 
    time_t lStart=time(0);
    time_t lEnd=0;
    

    u32 lCount=0;
    do{
      lTMC.StartSpill();
      bool lBusy=false;
      do{
	lBusy=lTMC.Busy();
      }while(lBusy);
      
      //cout<<"Status = 0x"<<hex<<lTMC.ReadStatus()<<dec<<endl;
      u16 lBuf[8192];
      lTMC.ReadTriggerRecordBuffer(lBuf, 8192);
      
      //cout<<"Status = 0x"<<hex<<lTMC.ReadStatus()<<dec<<endl;
      
      lCount++;

      if((lCount%1000)==0){
	lEnd=time(0);
	cout<<"Spill Count = "<<lCount<<", rate = "
	    <<(static_cast<double>(lCount)/(lEnd-lStart+1))<<std::endl;
	cout<<"Status = 0x"<<hex<<lTMC.ReadStatus()<<dec<<endl;
	if(!(lTMC.ReadStatus()&0x4)){
	  
	  break;
	}
      }
      

    }while(gEnd==0);

    cout<<"Status = 0x"<<hex<<lTMC.ReadStatus()<<dec<<endl;
    cout<<"Spill Count = "<<lCount<<std::endl;

  }catch(USBDAQ::USBDAQException & aExc){
    cerr<<"USBDAQException caught: \n";
    cerr<<aExc.What();
    cerr<<"\n";
  }catch(std::exception & aExc){
    cerr<<"std::exception caught: \n";
    cerr<<aExc.what();
    cerr<<"\n";
  }catch(...){
    cerr<<"unknown exception caught.\n";
  }

  return 0;
}
