#include <iostream>
#include "USBDAQException.hh"
#include "TPACMasterController.hh"
#include <time.h>

int main()
{
  using namespace std; 
  using namespace USBDAQ; 
  

  try{
    
    TPACMasterController lTMC;
    char lTimeBuf[256];
    time_t lTime=lTMC.ReadFirmwareBuildTime();
    cout<<"Firmware build = "<<lTMC.ReadFirmwareVersion()<<endl;
    cout<<"Firmware build time = "<<lTime
	<<"\n                      "
	<<ctime_r(&lTime, lTimeBuf)<<endl;

  
    
    // read back:
    
    cout<<dec<<"Reset Length = "<<lTMC.ReadResetLength()<<endl;
    cout<<"Spill Cycle Start = "<<lTMC.ReadSpillCycleStart()<<endl;
    cout<<"Bunch crossing length = "<<lTMC.ReadBunchCrossingLength()<<endl;
    cout<<"Bunch train length = "<<lTMC.ReadBunchTrainLength()<<endl;
    cout<<"Trigger enable mask = 0x"
	<<hex<<lTMC.ReadTriggerEnableMask()<<dec<<endl;

    cout<<"Trigger inversion mask = "
	<<hex<<lTMC.ReadTriggerInversionMask()<<dec<<endl;

    cout<<"Test trigger start = "
	<<lTMC.ReadTestTriggerStart()<<endl;

    cout<<"Test trigger end = "
	<<lTMC.ReadTestTriggerEnd()<<endl;
    
    cout<<"Status = "<<hex<<lTMC.ReadStatus()<<dec<<endl;
    
  }catch(USBDAQ::USBDAQException & aExc){
    cerr<<"USBDAQException caught: \n";
    cerr<<aExc.What();
    cerr<<"\n";
  }catch(std::exception & aExc){
    cerr<<"std::exception caught: \n";
    cerr<<aExc.what();
    cerr<<"\n";
  }catch(...){
    cerr<<"unknown exception caught.\n";
  }

  return 0;
}
