#include <iostream>
#include "USBDAQException.hh"
#include "TPACMasterController.hh"
#include <time.h>

int main()
{
  using namespace std; 
  using namespace USBDAQ; 
  

  try{
    
    TPACMasterController lTMC;
    char lTimeBuf[256];
    time_t lTime=lTMC.ReadFirmwareBuildTime();
    cout<<"Firmware build = "<<lTMC.ReadFirmwareVersion()<<endl;
    cout<<"Firmware build time = "<<lTime
	<<"\n                      "
	<<ctime_r(&lTime, lTimeBuf)<<endl;

  
    lTMC.SetTestBits(0x7);
    cout<<"Test bits = "<<lTMC.ReadTestBits()<<endl;
    cout<<"Trigger line state = 0x"<<hex<<lTMC.ReadTriggerInputState()<<endl;
 
  }catch(USBDAQ::USBDAQException & aExc){
    cerr<<"USBDAQException caught: \n";
    cerr<<aExc.What();
    cerr<<"\n";
  }catch(std::exception & aExc){
    cerr<<"std::exception caught: \n";
    cerr<<aExc.what();
    cerr<<"\n";
  }catch(...){
    cerr<<"unknown exception caught.\n";
  }

  return 0;
}
