#ifndef TPACMasterController_HH_
#define TPACMasterController_HH_

#include "TypeDefs.hh"
#include "USBDAQHardwareInterface.hh"

namespace USBDAQ
{
  
  class TPACMasterController
  {
  public:
    TPACMasterController();
    virtual ~TPACMasterController();
    
    enum ADDRESSES{
      REG0=1, 
      REG_RST_BXSTART=REG0,
      REG_BT_BX_LENGTH, 
      REG_INVERT_ENABLE, 
      REG_START_TT,
      REG_END_TT, 
      REG_JTAGACCESS, 
      TRIGGER,
      STATUS, 
      BUILD_TIME, 
      BUILD_VERSION,
#ifndef TPACMASTERCONTROLLER_FIRMWARE_V6
      TLU_BUFFER,
#endif
      ADDRESS_SIZE_
    };
 
  private: 
    void Trigger(u32 aVector, u32 aDuration=5);
    
  public: 
     
    
    // status(0) = spill active indicator
    // status(1) = buffer overflow
    // status(2) = buffer empty
    // status(3) = jtag tdo;
    // status(4) = jtag busy
    // status(5) = spill emulator busy
    u32 ReadStatus();
    
    u16 ReadTriggerInputState();
    void BufferFlush();


    bool Busy();

    void IssueTestTrigger(u16 aIdx, u32 aLen=100);
    void SetTestBits(u16 aTest); 
    u16 ReadTestBits(); 
    
    

    void StartSpill();

    void SetResetLength(u16 aResetLength);
    u16 ReadResetLength();
    
    void SetSpillCycleStart(u16 aSCStart);
    u16 ReadSpillCycleStart();

    void SetBunchCrossingLength(u16 aLength);
    u16 ReadBunchCrossingLength();
    
    
    void SetBunchTrainLength(u16 aLength);
    u16 ReadBunchTrainLength();
    

    void SetTriggerEnableMask(u16 aMask);
    u16 ReadTriggerEnableMask();
    
    void SetTriggerInversionMask(u16 aMask);
    u16 ReadTriggerInversionMask();
    
   
    void SetTestTriggerStart(u32 aStart);
    u32 ReadTestTriggerStart();

    void SetTestTriggerEnd(u32 aEnd);
    u32 ReadTestTriggerEnd();
    
    
    u32 ReadFirmwareBuildTime();
    u32 ReadFirmwareVersion();


    u32 ReadTluBuffer();
    void PopTluBuffer();


    u16 ReadTriggerRecordBuffer(u16 * aBuf, 
				u32 aBufLen);

    
  private:
    TPACMasterController(const TPACMasterController &);
    TPACMasterController & operator=(const TPACMasterController &);

    void Pause(u32 ams);
    
    //public: 
    // 
    //  bool JTAGBusAccess(bool aTMS, 
    // 		       bool aTDI);

  private: 
    USBDAQ::USBDAQHardwareInterface * mInterface;
    unsigned short mClockLock;
    
    unsigned short mTriggerRecordLength;

  };

}//~namespace T2KDAQ

#endif//~TPACMasterController_HH_

