#ifndef TestInterface_HH_
#define TestInterface_HH_

#include "TypeDefs.hh"
#include "USBDAQHardwareInterface.hh"

namespace USBDAQ
{
  
  class TestInterface
  {
  public:
    TestInterface();
    virtual ~TestInterface();
    
    enum ADDRESSES{
      REG0=1, 
      REG1, 
      REG2, 
      REG3,
      REG4, 
      REG5, 
      REG6, 
      REG7, 
      REG8, 
      STATUS, 
      TRIGGER,
      ADDRESS_SIZE_
    };
    
    

    void TestRegister(u32 aReg, u32 aVal);
    u32 TestRegister(u32 aReg);
 
    u32 ReadStatus();

    void Trigger(u32 aVector, u32 aDuration=5);

    void ManipulateBits();
    void FlashLeds();
    
    void BulkTest();

  private:
    TestInterface(const TestInterface &);
    TestInterface & operator=(const TestInterface &);

    void Pause(u32 ams);


  private: 
    USBDAQ::USBDAQHardwareInterface * mInterface;
    
  };

}//~namespace T2KDAQ

#endif//~TestInterface_HH_

