#ifndef _AddressMapper_HH
#define _AddressMapper_HH

#include "TypeDefs.hh"

namespace USBDAQ
{
  
  class AddressMapper
  {
  public:

    AddressMapper();
    AddressMapper(u32 aSpaceSize);
    ~AddressMapper();

    void SetAddressSpaceSize(u32 aSpaceSize);
    u32 GetAddressSpaceSize()const;
    
    u32 GetWriteAddress(u32 aAddr)const;
    u32 GetReadAddress(u32 aAddr)const;

  private:
    u32 mSpaceSize;
    const static u32 mWriteBit;
    const static u32 mReadMask;
  };
}

#endif //  _AddressMapper_HH
