#ifndef LinuxLibUsbInterface_HH
#define LinuxLibUsbInterface_HH

#include "USBDAQHardwareInterface.hh"
#include "LibUsbDevice.hh"
#include "UsbEndPoint.hh"

#include "AddressMapper.hh"

//#define EN_DEBUG_READBACK false

namespace USBDAQ
{


  class LinuxLibUsbInterface:public USBDAQHardwareInterface
  {
    
  public:

    //LinuxLibUsbInterface(const std::string & aConfig,
    //			 const std::string & aDevName);
    
    LinuxLibUsbInterface(const std::string & aConfig,
			 u16 aVendorId, 
			 u16 aDeviceId, 
			 u16 aBcdDeviceId);
    

    virtual ~LinuxLibUsbInterface();


    virtual void Read(u32 aAddr,
		      u32 & aData,
		      u32 aMask=0xffffffff);

    
    
    virtual void Write(u32 aAddr,
		       u32 aData, 
		       u32 aMask=0xffffffff);

    
    
    // bitwise register operations:
    virtual void SetBit(u32 aAddr, u16 aBit);
    virtual void ClearBit(u32 aAddr, u16 aBit);
    virtual bool ReadBit(u32 aAddr, u16 aBit);
    
    //
    virtual void ReadBlock(u8 * aBuf, u32 aLength);
    
    void ReadBlock2(u8 * aBuf, u32 aLength);
   
    
    virtual void WriteBlock(const u8 * aBuf, u32 aLength);

    virtual void SetAddressSpaceSize(u32 aAddrSize);
    

  private:
    void Reset();
    
    

  private:

    

    std::string mDeviceName;
    u16 mVendorId;
    u16 mDeviceId;
    u16 mBcdDeviceId;
    

    LibUsbDevice * mUsbDevice;
    UsbEndPoint mConfigIn;
    UsbEndPoint mStatOut;    
    UsbEndPoint mRawIn;
    UsbEndPoint mRawOut;

    AddressMapper mAddrMap;
    

  }; // ~class LinuxLibUsbInterface

}//~namespace USBDAQ


#endif //~LinuxLibUsbInterface_HH
