#ifndef SoftFifo_HH_
#define SoftFifo_HH_

#include "TypeDefs.hh"




namespace USBDAQ
{
  class SoftFifo
  {
  public:
    SoftFifo(int aBufDepth=512);
    virtual ~SoftFifo();
    
    void Reset();
    bool Empty();
    bool Full();
    
    int Content();
    
    int Extract(u8 * aDest, int aLength);
    
    int Insert(const u8 * aSrc, int aLength);
     

    SoftFifo(const SoftFifo &);
    SoftFifo & operator=(const SoftFifo &);
   
  private:
    int mDepth;
    int mIndexMask;
    int mR;
    int mW;
    u8 * mBuf;

  protected:
  };

}//~namespace USBDAQ

#endif//~SoftFifo_HH_

