#ifndef UsbEndPoint_HH
#define UsbEndPoint_HH

#include <iostream>
#include <string>

#include "TypeDefs.hh"

namespace USBDAQ
{
  

  
  class UsbEndPoint
  {
  public:
    
    UsbEndPoint(const std::string & aName);

    //UsbEndPoint(UsbEndPointFileReader & aEpr, const std::string & aName);

    ~UsbEndPoint();

    /*
     * returns the ep name.
     */
    std::string GetName()const;

    /*
     * returns the Identifier.
     */
    i32 GetId() const;
    void SetId(i32 aId);
    /*
     * returns the ep buffer size.
     */
    u32 GetBufferSize()const;
    
    /*
     * returns the ep buffer size.
     */
    void SetBufferSize(u32 aBufSize);
    
    /*
     * returns the readable flag.
     */
    bool IsReadable() const;
    void IsReadable(bool aIsReadable);

    /*
     * returns the writable flag.
     */
    bool IsWritable() const;
    void IsWritable(bool aIsWritable);

    /*
     * returns the endpoint purpose description.
     */
    std::string GetDescription()const;
    void SetDescription(const std::string & aDesc);
        
    
    
    //friend class UsbEndPointFileReader;
    friend std::ostream & operator<<(std::ostream & aOs, const UsbEndPoint & aEp);
  private:// methods
    
    UsbEndPoint();
    

  private:// members
    
    std::string mName;
    i32 mId;      // endpoint number identifier
    bool mRead;   // endpoint is readable
    bool mWrite;  // endpoint is writable 
    u32 mBufferSize; // ep buffer size
    std::string mDescription; // use of the endpoint.
    
  };//~class UsbEndPoint


  std::ostream & operator<<(std::ostream & aOs, const UsbEndPoint & aEp);

}//~namespace USBDAQ

#endif //~UsbEndPoint_HH
