#ifndef USBDAQHardwareInterface_HH
#define USBDAQHardwareInterface_HH

#include <string>

#include "TypeDefs.hh"


namespace USBDAQ
{

  /*
   * USBDAQHardwareInterface
   *
   * M.Noy
   * 06.07
   */

  class USBDAQHardwareInterface
  {
  public:
    
    USBDAQHardwareInterface(const std::string & aConfig):
      mConfig(aConfig){}
 
    USBDAQHardwareInterface()
    {}
    

    /*
     * virtual destructor.
     *
     */
    virtual ~USBDAQHardwareInterface(){}
    

    
    /*
     * Reads from the status register address space on the 
     * USBDAQ card addressed by aStatusAddress, and puts the 
     * result into aData.
     *
     */

    virtual void Read(u32 aAddr, u32 & aData, u32 aMask=0xffffffff)=0;

    // virtual void Read(const USBDAQAddress & aStatusAddress, 
// 		      u8 * aData, u32 aLength)=0;

    /*
     * Writes the data passed in aData to the command address 
     * space of the IDAQ card addressed by aCmdAddress.
     *
     */
    virtual void Write(u32 aAddr, u32 aData, u32 aMask=0xffffffff)=0;

    //   virtual void Write(const USBDAQAddress & aCmdAddress, 
    // 		       const u8 * aData, u32 aLength)=0;
    

    // bitwise register operations:
    virtual void SetBit(u32 aAddr, u16 aBit)=0;
    virtual void ClearBit(u32 aAddr, u16 aBit)=0;
    virtual bool ReadBit(u32 aAddr, u16 aBit)=0;

 
    /*
     * Reads out a raw block of data of length aLength bytes 
     * 
     */
    virtual void ReadBlock(u8 * aBuf, u32 aLength)=0;

    /*
     * Transfers a raw block of data of length aLength bytes 
     * to the USBDAQ.
     *
     */
    virtual void WriteBlock(const u8 * aBuf, u32 aLength)=0;
    
    virtual void SetAddressSpaceSize(u32 aAddrSize)=0;

  protected:
    
    std::string mConfig;

  };//~class USBDAQHardwareInterface


}//~namespace USBDAQ


#endif //~USBDAQHardwareInterface_HH
