#include "AddressMapper.hh"

namespace USBDAQ
{
  const u32 AddressMapper::mWriteBit=0x80000000;
  const u32 AddressMapper::mReadMask=0x7fffffff;


  AddressMapper::AddressMapper():
    mSpaceSize(4)
  {
    
  }
  AddressMapper::AddressMapper(u32 aSpaceSize):
    mSpaceSize(aSpaceSize)
  {

  }
  
  AddressMapper::~AddressMapper(){
    
  }

  void AddressMapper::SetAddressSpaceSize(u32 aSpaceSize){
    mSpaceSize=aSpaceSize;
  }
  

  u32 AddressMapper::GetAddressSpaceSize()const{
    return mSpaceSize;
  }

  u32 AddressMapper::GetWriteAddress(u32 aAddr)const{
    if(aAddr>mSpaceSize){
      // error:
      
    }
    return (mWriteBit|aAddr);
  }

  u32 AddressMapper::GetReadAddress(u32 aAddr)const{
    if(aAddr>mSpaceSize){
      //error:
      
    }
    
    aAddr=mSpaceSize-aAddr;
    aAddr&=mReadMask;
    return aAddr;
  }
  
}

