#include "MemoryAllocationException.hh"

namespace USBDAQ
{
  
  MemoryAllocationException::MemoryAllocationException(const std::string & aType, 
						       u32 aQuant):
    USBDAQException("")
  {
    std::string lTemp("Memory allocation for ");
    lTemp+=USBDAQ::USBDAQException::ToString(aQuant);
    lTemp+=" object";
    lTemp+=aQuant==1?" ":"s ";
    lTemp+="of type ";
    lTemp+=aType;
    mErrorDescription=lTemp;
  }
  
  MemoryAllocationException::~MemoryAllocationException()throw()
  {
  }



}//~namespace USBDAQ
