#include "USBDAQException.hh"
#include "TypeDefs.hh"

#ifdef __GNUG__
#include <cxxabi.h>
#endif

namespace USBDAQ
{


  USBDAQException::USBDAQException(const std::string & aErrorDescription):
    mErrorDescription(aErrorDescription)
  {
    
  }
  



  /*
   * method inherited from std::exception. 
   * 
   *
   */
  const char * USBDAQException::what()const throw()
  {
    // let What() do the formatting, then just 
    // obtain the pointer to the c-string and return. 
    return this->What().c_str();
  }
  
  std::string USBDAQException::What()const throw()
  {
    std::string lEol("\n========================================================\n");
    std::string lTempBuf(lEol);

    lTempBuf+=std::string("Exception of type: ")+mExceptionName;
    lTempBuf+=std::string("\nRaised in function: ")+GetFunctionOfOrigin();
    lTempBuf+=std::string(" in file: ")+GetFileOfOrigin()
      +std::string(", line: ")+ToString(GetLineOfOrigin());
    
    lTempBuf+=std::string("\nWith message: ")+mErrorDescription;
    
    lTempBuf+=lEol;
    return lTempBuf;
  }
  

  std::string USBDAQException::History()const throw()
  {
    std::string lTempBuf("History:\n");
    u16 lCount=0;
    for(std::list<ExceptionHistoryPoint>::const_iterator i=mHistory.begin();
	i!=mHistory.end(); ++i)
      {
	lTempBuf+=USBDAQException::ToString(lCount++);
	lTempBuf+=" : ";
	lTempBuf+=i->mFunction;
	lTempBuf+=std::string(" in file:")+i->mFile;
	lTempBuf+=std::string(", line:")+ToString(i->mLine);
	lTempBuf+='\n';
      }
    if(mHistory.begin()==mHistory.end())
      {
	lTempBuf+="History is empty.";
      }
    return lTempBuf;
  }

  void USBDAQException::AddLocation(std::string aFunc,
				   std::string aFile,
				   int aLine)
  {
    // what am i?
    this->SetType();    
    // add information passed to the function
    // to the history list...
    this->AddHistoryElement(aFunc,aFile,aLine);
  }

  std::string USBDAQException::GetFunctionOfOrigin()const
  {
    // check to see if the history contains
    // anything, if not, return the default string.
    if(mHistory.begin()!=mHistory.end())
      return mHistory.begin()->mFunction;
    return std::string("History unpopulated.");
  }

  std::string USBDAQException::GetFileOfOrigin()const
  {
    // check to see if the history contains
    // anything, if not, return the default string.
    if(mHistory.begin()!=mHistory.end())
      return mHistory.begin()->mFile;
    return std::string("History unpopulated.");
  }

  int USBDAQException::GetLineOfOrigin()const
  {   
    // check to see if the history contains
    // anything, if not, return -1.
    if(mHistory.begin()!=mHistory.end())
      return mHistory.begin()->mLine;
    return -1; 
  }

  void USBDAQException::AddHistoryElement(const std::string & aFunc,
					 const std::string & aFile,
					 int aLine)
  {
    ExceptionHistoryPoint lHistPoint;
    lHistPoint.mFunction=aFunc;
    lHistPoint.mFile=aFile;
    lHistPoint.mLine=aLine;
    mHistory.push_back(lHistPoint);
  }
 
  void USBDAQException::SetErrorDescription(const std::string & aNewDesc)
  {
    mErrorDescription=aNewDesc;
  }

  void USBDAQException::SetType()
  {
    // this is fugly but necessary due to the 
    // way that typeid::name() returns the 
    // object type name under g++. 
    // #ifdef __GNUG__
    int lStatus=0;
    mExceptionName=std::string(abi::__cxa_demangle(typeid(*this).name(), 0,0, &lStatus));
    // #else
    // mExceptionName=std::string(typeid(*this).name());
    // #endif
  }

 

  USBDAQException & operator<<(USBDAQException & aExc, u8 aData)
  {
    std::ostringstream lOss;
    lOss<<aData;
    aExc.mErrorDescription+=lOss.str();
    return aExc;
  }  
  
  USBDAQException & operator<<(USBDAQException & aExc, i8 aData)
  {
    std::ostringstream lOss;
    lOss<<aData;
    aExc.mErrorDescription+=lOss.str();
    return aExc;
  }
  
  USBDAQException & operator<<(USBDAQException & aExc, u16 aData)
  {
    std::ostringstream lOss;
    lOss<<aData;
    aExc.mErrorDescription+=lOss.str();
    return aExc;
  }
  

  USBDAQException & operator<<(USBDAQException & aExc, i16 aData)
  {
    std::ostringstream lOss;
    lOss<<aData;
    aExc.mErrorDescription+=lOss.str();
    return aExc;
  }
  
  USBDAQException & operator<<(USBDAQException & aExc, u32 aData)
  {
    std::ostringstream lOss;
    lOss<<aData;
    aExc.mErrorDescription+=lOss.str();
    return aExc;
  }
  
  USBDAQException & operator<<(USBDAQException & aExc, i32 aData)
  {
    std::ostringstream lOss;
    lOss<<aData;
    aExc.mErrorDescription+=lOss.str();
    return aExc;
  }

  // USBDAQException & operator<<(USBDAQException & aExc, const IDAQAddress & aData)
//   {
//     std::ostringstream lOss;
//     lOss<<std::hex<<"0x"<<aData;
//     aExc.mErrorDescription+=lOss.str();
//     return aExc;
//   }
  
  USBDAQException & operator<<(USBDAQException & aExc, const char * aData)
  {
    const std::string lTemp(aData);
    //std::ostringstream lOss;
    //lOss<<aData;
    aExc.mErrorDescription+=lTemp;
    return aExc;
  }
  
  USBDAQException & operator<<(USBDAQException & aExc, const std::string & aData)
  {
    std::ostringstream lOss;
    lOss<<aData;
    aExc.mErrorDescription+=lOss.str();
    return aExc;
  }


  std::ostream & operator<<(std::ostream  & aOs, USBDAQException & aExc){
    aOs<<aExc.What()<<'\n';
    aOs<<aExc.History()<<'\n';
    return aOs;
  }


}//~namespace USBDAQ
