#include "UsbEndPoint.hh"


namespace USBDAQ
{

//   UsbEndPoint::UsbEndPoint(UsbEndPointFileReader & aEpr, const std::string & aName):
//     mName(aName),
//     mId(-1),    
//     mRead(false),
//     mWrite(false),
//     mBufferSize(0),
//     mDescription("Unintialised.")
//   {
//     //aEpr.Populate(mName, *this);
//   }

  UsbEndPoint::UsbEndPoint(const std::string & aName):
    mName(aName),
    mId(-1),    
    mRead(false),
    mWrite(false),
    mBufferSize(0),
    mDescription("Unintialised.")
  {
    
  }


  UsbEndPoint::~UsbEndPoint(){}

  std::string UsbEndPoint::GetName()const
  {
    return mName;
  }

  i32 UsbEndPoint::GetId()const
  {    
    return mId;
  }
  void UsbEndPoint::SetId(i32 aId)
  {    
    mId=aId;
  }

  u32 UsbEndPoint::GetBufferSize()const 
  {
    return mBufferSize;
  }
  void UsbEndPoint::SetBufferSize(u32 aBufSize) 
  {
    mBufferSize=aBufSize;
  }
  
  bool UsbEndPoint::IsReadable()const 
  {
    return mRead;
  }
  void UsbEndPoint::IsReadable(bool aRead)
  {
    mRead=aRead;
  }

  bool UsbEndPoint::IsWritable()const
  {
    return mWrite;
  } 
  void UsbEndPoint::IsWritable(bool aWrite)
  {
    mWrite=aWrite;
  }


  std::string UsbEndPoint::GetDescription()const
  {
    return mDescription;
  }

  void  UsbEndPoint::SetDescription(const std::string & aDesc){
    mDescription=aDesc;
  }

  std::ostream & operator<<(std::ostream & aOs, const UsbEndPoint & aEp)
  {
    aOs<<aEp.mName<<" "
       <<aEp.mId<<" "
       <<aEp.mRead<<" "
       <<aEp.mWrite<<" "
       <<aEp.mBufferSize<<" "
       <<aEp.mDescription;
    return aOs;
  }

}//~namespace USBDAQ
