////////////////////////////////////////////////////////////////////////////////
//   ____  ____   
//  /   /\/   /  
// /___/  \  /   
// \   \   \/  
//  \   \        Copyright (c) 2003-2004 Xilinx, Inc.
//  /   /        All Right Reserved. 
// /---/   /\     
// \   \  /  \  
//  \___\/\___\
////////////////////////////////////////////////////////////////////////////////

#ifndef H_Xilinxcorelib_iputils_std_logic_unsigned_H
#define H_Xilinxcorelib_iputils_std_logic_unsigned_H

#ifdef __MINGW32__
#include "xsimMinGW.h"
#else
#include "xsim.h"
#endif


#include "xilinxcorelib.auxlib/iputils_std_logic_arith/iputils_std_logic_arith.h"
#include "ieee/std_logic_1164/std_logic_1164.h"

class Xilinxcorelib_iputils_std_logic_unsigned: public HSim__s6 {
public:
/* subprogram name + */
char *Add18(HSimConstraints *reConstr, const char *Ec, const HSimConstraints *constrEc, const char *Ee, const HSimConstraints *constrEe);
/* subprogram name + */
char *Add27(HSimConstraints *reConstr, const char *Em, const HSimConstraints *constrEm, const int Eq);
/* subprogram name + */
char *Add35(HSimConstraints *reConstr, const int Ew, const char *Ey, const HSimConstraints *constrEy);
/* subprogram name + */
char *Add44(HSimConstraints *reConstr, const char *EE, const HSimConstraints *constrEE, const char EH);
/* subprogram name + */
char *Add52(HSimConstraints *reConstr, const char EN, const char *EQ, const HSimConstraints *constrEQ);
/* subprogram name - */
char *Subtract60(HSimConstraints *reConstr, const char *EW, const HSimConstraints *constrEW, const char *EY, const HSimConstraints *constrEY);
/* subprogram name - */
char *Subtract68(HSimConstraints *reConstr, const char *E14, const HSimConstraints *constrE14, const int E16);
/* subprogram name - */
char *Subtract76(HSimConstraints *reConstr, const int E1c, const char *E1e, const HSimConstraints *constrE1e);
/* subprogram name - */
char *Subtract84(HSimConstraints *reConstr, const char *E1k, const HSimConstraints *constrE1k, const char E1n);
/* subprogram name - */
char *Subtract92(HSimConstraints *reConstr, const char E1u, const char *E1w, const HSimConstraints *constrE1w);
/* subprogram name + */
char *Add98(HSimConstraints *reConstr, const char *E1C, const HSimConstraints *constrE1C);
/* subprogram name * */
char *Multiply106(HSimConstraints *reConstr, const char *E1I, const HSimConstraints *constrE1I, const char *E1K, const HSimConstraints *constrE1K);
/* subprogram name < */
char Less114(const char *E1R, const HSimConstraints *constrE1R, const char *E1T, const HSimConstraints *constrE1T);
/* subprogram name < */
char Less122(const char *E1Z, const HSimConstraints *constrE1Z, const int E21);
/* subprogram name < */
char Less130(const int E27, const char *E29, const HSimConstraints *constrE29);
/* subprogram name <= */
char LessEqual138(const char *E2f, const HSimConstraints *constrE2f, const char *E2h, const HSimConstraints *constrE2h);
/* subprogram name <= */
char LessEqual146(const char *E2p, const HSimConstraints *constrE2p, const int E2r);
/* subprogram name <= */
char LessEqual154(const int E2x, const char *E2z, const HSimConstraints *constrE2z);
/* subprogram name > */
char Greater162(const char *E2F, const HSimConstraints *constrE2F, const char *E2H, const HSimConstraints *constrE2H);
/* subprogram name > */
char Greater170(const char *E2N, const HSimConstraints *constrE2N, const int E2Q);
/* subprogram name > */
char Greater178(const int E2W, const char *E2Y, const HSimConstraints *constrE2Y);
/* subprogram name >= */
char GreaterEqual186(const char *E34, const HSimConstraints *constrE34, const char *E36, const HSimConstraints *constrE36);
/* subprogram name >= */
char GreaterEqual194(const char *E3c, const HSimConstraints *constrE3c, const int E3e);
/* subprogram name >= */
char GreaterEqual202(const int E3k, const char *E3n, const HSimConstraints *constrE3n);
/* subprogram name = */
char Equal210(const char *E3u, const HSimConstraints *constrE3u, const char *E3w, const HSimConstraints *constrE3w);
/* subprogram name = */
char Equal218(const char *E3C, const HSimConstraints *constrE3C, const int E3E);
/* subprogram name = */
char Equal226(const int E3K, const char *E3M, const HSimConstraints *constrE3M);
/* subprogram name /= */
char notEqual234(const char *E3T, const HSimConstraints *constrE3T, const char *E3V, const HSimConstraints *constrE3V);
/* subprogram name /= */
char notEqual242(const char *E41, const HSimConstraints *constrE41, const int E43);
/* subprogram name /= */
char notEqual250(const int E49, const char *E4b, const HSimConstraints *constrE4b);
/* subprogram name SHL */
char *G4n(HSimConstraints *reConstr, const char *E4h, const HSimConstraints *constrE4h, const char *E4j, const HSimConstraints *constrE4j);
/* subprogram name SHR */
char *G4w(HSimConstraints *reConstr, const char *E4r, const HSimConstraints *constrE4r, const char *E4t, const HSimConstraints *constrE4t);
/* subprogram name CONV_INTEGER */
int G4C(const char *E4z, const HSimConstraints *constrE4z);

public:
/* subprogram name maximum */
int Fh(const int Cc, const int Ce);

public:
  Xilinxcorelib_iputils_std_logic_unsigned(const HSimString &name);
  ~Xilinxcorelib_iputils_std_logic_unsigned();
};

extern Xilinxcorelib_iputils_std_logic_unsigned *XilinxcorelibIputils_std_logic_unsigned;

#endif
