library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity spill_emulator_tb is
end entity spill_emulator_tb;


architecture v0 of spill_emulator_tb is

  component spill_emulator
    port(
      rst : in std_logic;
      clk : in std_logic;
      buffer_rst: in std_logic;
      reset_length : in std_logic_vector(15 downto 0);
      bx_count_start : in std_logic_vector(12 downto 0);
      bx_length: in std_logic_vector(7 downto 0);
      bt_length : in std_logic_vector(12 downto 0);

      busy: out std_logic;
      spill_start : in std_logic;
      spill_active : out std_logic;
      bx_end : out std_logic;

      start_tt: in std_logic_vector(31 downto 0);
      end_tt: in std_logic_vector(31 downto 0);
      test_trigger: out std_logic;
      
      trigger_input : in std_logic_vector(15 downto 0);

      ro_clk: in std_logic;
      buf_overflow : out std_logic;
      buf_empty : out std_logic;
      buf_rden : in std_logic;
      buf_data : out std_logic_vector(15 downto 0)
      );
  end component spill_emulator;
  
  for all : spill_emulator use entity work.spill_emulator;

  
  -- signals for spill_emulator
  signal int_rst:std_logic:='1';
  signal int_clk:std_logic:='0';
  signal int_reset_length:std_logic_vector(15 downto 0):="0000000000000000";
  signal int_bx_count_start:std_logic_vector(12 downto 0):="0000000000000";
  signal int_bx_length: std_logic_vector(7 downto 0);
  signal int_bt_length:std_logic_vector(12 downto 0):="0000000000000";
  signal int_spill_start:std_logic:='0';
  signal int_spill_active:std_logic:='0';
  signal int_bx_end:std_logic:='0';
  signal int_trigger_input:std_logic_vector(15 downto 0):="0000000000000000";
  signal int_buf_overflow:std_logic:='0';
  signal int_buf_empty:std_logic:='0';
  signal int_buf_rden:std_logic:='0';
  signal int_buf_data:std_logic_vector(15 downto 0):="0000000000000000";



  signal int_start_tt: std_logic_vector(31 downto 0);
  signal int_end_tt: std_logic_vector(31 downto 0);
  
  signal int_test_trigger: std_logic;

  signal int_busy: std_logic;
  
begin 

    
  tb:process
  begin 

    int_reset_length<="0000000000001000";
    int_bx_count_start<="1000000000000";
    int_bt_length     <="0000100000000";
    int_spill_start<='0';
    int_trigger_input<="0000000000000000";
    int_bx_length<="00001110";   
    int_buf_rden<='0';

    
    int_start_tt<="00000000000000000000000000100000";
    int_end_tt  <="00000000000000000000000001000000";

    
    wait until int_rst='0';
    wait for 100 ns;

    int_spill_start<='1';
    wait for 100 ns;

    int_spill_start<='0';

    wait until int_spill_active='1' ;

    wait until int_spill_active='0' ;
    
    
    int_buf_rden<='1';

    wait until int_buf_empty='1'; 
    
    int_buf_rden<='0';
    
    wait ;

    
  end process tb;

  tb_rst_gen:process
  begin
    int_rst<='1';
    wait for 500 ns; 
    int_rst<='0';

    wait; 
    
  end process tb_rst_gen;
    
  tb_clk_gen:process
  begin 
    int_clk<='0' after 1 ns ;
    wait for 12 ns;
    int_clk<='1' after 1 ns ;
    wait for 12 ns ; 
  end process tb_clk_gen;



  u_spill_emulator:spill_emulator
    port map(
      rst=>int_rst,
      clk=>int_clk,
      buffer_rst=>int_rst,
      reset_length=>int_reset_length,
      bx_length=>int_bx_length,
      bx_count_start=>int_bx_count_start,
      bt_length=>int_bt_length,
      busy=>int_busy, 
      spill_start=>int_spill_start,
      spill_active=>int_spill_active,
      bx_end=>int_bx_end,
      start_tt=>int_start_tt, 
      end_tt=>int_end_tt,
      test_trigger=>int_test_trigger,
      trigger_input=>int_trigger_input,

      ro_clk=>int_clk,
      buf_overflow=>int_buf_overflow,
      buf_empty=>int_buf_empty,
      buf_rden=>int_buf_rden,
      buf_data=>int_buf_data);

end architecture v0;
