////////////////////////////////////////////////////////////////////////////////
//   ____  ____   
//  /   /\/   /  
// /___/  \  /   
// \   \   \/  
//  \   \        Copyright (c) 2003-2004 Xilinx, Inc.
//  /   /        All Right Reserved. 
// /---/   /\     
// \   \  /  \  
//  \___\/\___\
////////////////////////////////////////////////////////////////////////////////

#ifndef H_Xilinxcorelib_iputils_std_logic_arith_H
#define H_Xilinxcorelib_iputils_std_logic_arith_H

#ifdef __MINGW32__
#include "xsimMinGW.h"
#else
#include "xsim.h"
#endif


#include "ieee/std_logic_1164/std_logic_1164.h"

class Xilinxcorelib_iputils_std_logic_arith: public HSim__s6 {
public:
  HSimArrayType Unsigned;
  HSimArrayType Signed;
  HSimIntegerType Small_int;
/* subprogram name + */
char *Add30(HSimConstraints *reConstr, const char *Eq, const HSimConstraints *constrEq, const char *Es, const HSimConstraints *constrEs);
/* subprogram name + */
char *Add39(HSimConstraints *reConstr, const char *EA, const HSimConstraints *constrEA, const char *EC, const HSimConstraints *constrEC);
/* subprogram name + */
char *Add47(HSimConstraints *reConstr, const char *EI, const HSimConstraints *constrEI, const char *EK, const HSimConstraints *constrEK);
/* subprogram name + */
char *Add55(HSimConstraints *reConstr, const char *ER, const HSimConstraints *constrER, const char *ET, const HSimConstraints *constrET);
/* subprogram name + */
char *Add64(HSimConstraints *reConstr, const char *EZ, const HSimConstraints *constrEZ, const int E12);
/* subprogram name + */
char *Add72(HSimConstraints *reConstr, const int E18, const char *E1a, const HSimConstraints *constrE1a);
/* subprogram name + */
char *Add80(HSimConstraints *reConstr, const char *E1g, const HSimConstraints *constrE1g, const int E1i);
/* subprogram name + */
char *Add88(HSimConstraints *reConstr, const int E1q, const char *E1s, const HSimConstraints *constrE1s);
/* subprogram name + */
char *Add97(HSimConstraints *reConstr, const char *E1y, const HSimConstraints *constrE1y, const char E1B);
/* subprogram name + */
char *Add105(HSimConstraints *reConstr, const char E1H, const char *E1J, const HSimConstraints *constrE1J);
/* subprogram name + */
char *Add113(HSimConstraints *reConstr, const char *E1Q, const HSimConstraints *constrE1Q, const char E1S);
/* subprogram name + */
char *Add121(HSimConstraints *reConstr, const char E1Y, const char *E20, const HSimConstraints *constrE20);
/* subprogram name + */
char *Add129(HSimConstraints *reConstr, const char *E26, const HSimConstraints *constrE26, const char *E28, const HSimConstraints *constrE28);
/* subprogram name + */
char *Add137(HSimConstraints *reConstr, const char *E2e, const HSimConstraints *constrE2e, const char *E2g, const HSimConstraints *constrE2g);
/* subprogram name + */
char *Add145(HSimConstraints *reConstr, const char *E2n, const HSimConstraints *constrE2n, const char *E2q, const HSimConstraints *constrE2q);
/* subprogram name + */
char *Add153(HSimConstraints *reConstr, const char *E2w, const HSimConstraints *constrE2w, const char *E2y, const HSimConstraints *constrE2y);
/* subprogram name + */
char *Add161(HSimConstraints *reConstr, const char *E2E, const HSimConstraints *constrE2E, const int E2G);
/* subprogram name + */
char *Add169(HSimConstraints *reConstr, const int E2M, const char *E2P, const HSimConstraints *constrE2P);
/* subprogram name + */
char *Add177(HSimConstraints *reConstr, const char *E2V, const HSimConstraints *constrE2V, const int E2X);
/* subprogram name + */
char *Add185(HSimConstraints *reConstr, const int E33, const char *E35, const HSimConstraints *constrE35);
/* subprogram name + */
char *Add193(HSimConstraints *reConstr, const char *E3b, const HSimConstraints *constrE3b, const char E3d);
/* subprogram name + */
char *Add201(HSimConstraints *reConstr, const char E3j, const char *E3m, const HSimConstraints *constrE3m);
/* subprogram name + */
char *Add209(HSimConstraints *reConstr, const char *E3t, const HSimConstraints *constrE3t, const char E3v);
/* subprogram name + */
char *Add217(HSimConstraints *reConstr, const char E3B, const char *E3D, const HSimConstraints *constrE3D);
/* subprogram name - */
char *Subtract225(HSimConstraints *reConstr, const char *E3J, const HSimConstraints *constrE3J, const char *E3L, const HSimConstraints *constrE3L);
/* subprogram name - */
char *Subtract233(HSimConstraints *reConstr, const char *E3S, const HSimConstraints *constrE3S, const char *E3U, const HSimConstraints *constrE3U);
/* subprogram name - */
char *Subtract241(HSimConstraints *reConstr, const char *E40, const HSimConstraints *constrE40, const char *E42, const HSimConstraints *constrE42);
/* subprogram name - */
char *Subtract249(HSimConstraints *reConstr, const char *E48, const HSimConstraints *constrE48, const char *E4a, const HSimConstraints *constrE4a);
/* subprogram name - */
char *Subtract257(HSimConstraints *reConstr, const char *E4g, const HSimConstraints *constrE4g, const int E4i);
/* subprogram name - */
char *Subtract265(HSimConstraints *reConstr, const int E4q, const char *E4s, const HSimConstraints *constrE4s);
/* subprogram name - */
char *Subtract273(HSimConstraints *reConstr, const char *E4y, const HSimConstraints *constrE4y, const int E4A);
/* subprogram name - */
char *Subtract281(HSimConstraints *reConstr, const int E4G, const char *E4I, const HSimConstraints *constrE4I);
/* subprogram name - */
char *Subtract289(HSimConstraints *reConstr, const char *E4P, const HSimConstraints *constrE4P, const char E4R);
/* subprogram name - */
char *Subtract297(HSimConstraints *reConstr, const char E4X, const char *E4Z, const HSimConstraints *constrE4Z);
/* subprogram name - */
char *Subtract305(HSimConstraints *reConstr, const char *E55, const HSimConstraints *constrE55, const char E57);
/* subprogram name - */
char *Subtract313(HSimConstraints *reConstr, const char E5d, const char *E5f, const HSimConstraints *constrE5f);
/* subprogram name - */
char *Subtract321(HSimConstraints *reConstr, const char *E5m, const HSimConstraints *constrE5m, const char *E5p, const HSimConstraints *constrE5p);
/* subprogram name - */
char *Subtract329(HSimConstraints *reConstr, const char *E5v, const HSimConstraints *constrE5v, const char *E5x, const HSimConstraints *constrE5x);
/* subprogram name - */
char *Subtract337(HSimConstraints *reConstr, const char *E5D, const HSimConstraints *constrE5D, const char *E5F, const HSimConstraints *constrE5F);
/* subprogram name - */
char *Subtract345(HSimConstraints *reConstr, const char *E5L, const HSimConstraints *constrE5L, const char *E5N, const HSimConstraints *constrE5N);
/* subprogram name - */
char *Subtract353(HSimConstraints *reConstr, const char *E5U, const HSimConstraints *constrE5U, const int E5W);
/* subprogram name - */
char *Subtract361(HSimConstraints *reConstr, const int E62, const char *E64, const HSimConstraints *constrE64);
/* subprogram name - */
char *Subtract369(HSimConstraints *reConstr, const char *E6a, const HSimConstraints *constrE6a, const int E6c);
/* subprogram name - */
char *Subtract377(HSimConstraints *reConstr, const int E6i, const char *E6k, const HSimConstraints *constrE6k);
/* subprogram name - */
char *Subtract385(HSimConstraints *reConstr, const char *E6s, const HSimConstraints *constrE6s, const char E6u);
/* subprogram name - */
char *Subtract393(HSimConstraints *reConstr, const char E6A, const char *E6C, const HSimConstraints *constrE6C);
/* subprogram name - */
char *Subtract401(HSimConstraints *reConstr, const char *E6I, const HSimConstraints *constrE6I, const char E6K);
/* subprogram name - */
char *Subtract409(HSimConstraints *reConstr, const char E6R, const char *E6T, const HSimConstraints *constrE6T);
/* subprogram name + */
char *Add415(HSimConstraints *reConstr, const char *E6Z, const HSimConstraints *constrE6Z);
/* subprogram name + */
char *Add421(HSimConstraints *reConstr, const char *E75, const HSimConstraints *constrE75);
/* subprogram name - */
char *Subtract427(HSimConstraints *reConstr, const char *E7b, const HSimConstraints *constrE7b);
/* subprogram name ABS */
char *G7k(HSimConstraints *reConstr, const char *E7h, const HSimConstraints *constrE7h);
/* subprogram name + */
char *Add439(HSimConstraints *reConstr, const char *E7p, const HSimConstraints *constrE7p);
/* subprogram name + */
char *Add445(HSimConstraints *reConstr, const char *E7v, const HSimConstraints *constrE7v);
/* subprogram name - */
char *Subtract451(HSimConstraints *reConstr, const char *E7B, const HSimConstraints *constrE7B);
/* subprogram name ABS */
char *G7K(HSimConstraints *reConstr, const char *E7H, const HSimConstraints *constrE7H);
/* subprogram name * */
char *Multiply465(HSimConstraints *reConstr, const char *E7N, const HSimConstraints *constrE7N, const char *E7Q, const HSimConstraints *constrE7Q);
/* subprogram name * */
char *Multiply473(HSimConstraints *reConstr, const char *E7W, const HSimConstraints *constrE7W, const char *E7Y, const HSimConstraints *constrE7Y);
/* subprogram name * */
char *Multiply481(HSimConstraints *reConstr, const char *E84, const HSimConstraints *constrE84, const char *E86, const HSimConstraints *constrE86);
/* subprogram name * */
char *Multiply489(HSimConstraints *reConstr, const char *E8c, const HSimConstraints *constrE8c, const char *E8e, const HSimConstraints *constrE8e);
/* subprogram name * */
char *Multiply497(HSimConstraints *reConstr, const char *E8k, const HSimConstraints *constrE8k, const char *E8n, const HSimConstraints *constrE8n);
/* subprogram name * */
char *Multiply505(HSimConstraints *reConstr, const char *E8u, const HSimConstraints *constrE8u, const char *E8w, const HSimConstraints *constrE8w);
/* subprogram name * */
char *Multiply513(HSimConstraints *reConstr, const char *E8C, const HSimConstraints *constrE8C, const char *E8E, const HSimConstraints *constrE8E);
/* subprogram name * */
char *Multiply521(HSimConstraints *reConstr, const char *E8K, const HSimConstraints *constrE8K, const char *E8M, const HSimConstraints *constrE8M);
/* subprogram name < */
char Less529(const char *E8T, const HSimConstraints *constrE8T, const char *E8V, const HSimConstraints *constrE8V);
/* subprogram name < */
char Less537(const char *E91, const HSimConstraints *constrE91, const char *E93, const HSimConstraints *constrE93);
/* subprogram name < */
char Less545(const char *E99, const HSimConstraints *constrE99, const char *E9b, const HSimConstraints *constrE9b);
/* subprogram name < */
char Less553(const char *E9h, const HSimConstraints *constrE9h, const char *E9j, const HSimConstraints *constrE9j);
/* subprogram name < */
char Less561(const char *E9r, const HSimConstraints *constrE9r, const int E9t);
/* subprogram name < */
char Less569(const int E9z, const char *E9B, const HSimConstraints *constrE9B);
/* subprogram name < */
char Less577(const char *E9H, const HSimConstraints *constrE9H, const int E9J);
/* subprogram name < */
char Less585(const int E9Q, const char *E9S, const HSimConstraints *constrE9S);
/* subprogram name <= */
char LessEqual593(const char *E9Y, const HSimConstraints *constrE9Y, const char *Ea0, const HSimConstraints *constrEa0);
/* subprogram name <= */
char LessEqual601(const char *Ea6, const HSimConstraints *constrEa6, const char *Ea8, const HSimConstraints *constrEa8);
/* subprogram name <= */
char LessEqual609(const char *Eae, const HSimConstraints *constrEae, const char *Eag, const HSimConstraints *constrEag);
/* subprogram name <= */
char LessEqual617(const char *Ean, const HSimConstraints *constrEan, const char *Eaq, const HSimConstraints *constrEaq);
/* subprogram name <= */
char LessEqual625(const char *Eaw, const HSimConstraints *constrEaw, const int Eay);
/* subprogram name <= */
char LessEqual633(const int EaE, const char *EaG, const HSimConstraints *constrEaG);
/* subprogram name <= */
char LessEqual641(const char *EaM, const HSimConstraints *constrEaM, const int EaP);
/* subprogram name <= */
char LessEqual649(const int EaV, const char *EaX, const HSimConstraints *constrEaX);
/* subprogram name > */
char Greater657(const char *Eb3, const HSimConstraints *constrEb3, const char *Eb5, const HSimConstraints *constrEb5);
/* subprogram name > */
char Greater665(const char *Ebb, const HSimConstraints *constrEbb, const char *Ebd, const HSimConstraints *constrEbd);
/* subprogram name > */
char Greater673(const char *Ebj, const HSimConstraints *constrEbj, const char *Ebm, const HSimConstraints *constrEbm);
/* subprogram name > */
char Greater681(const char *Ebt, const HSimConstraints *constrEbt, const char *Ebv, const HSimConstraints *constrEbv);
/* subprogram name > */
char Greater689(const char *EbB, const HSimConstraints *constrEbB, const int EbD);
/* subprogram name > */
char Greater697(const int EbJ, const char *EbL, const HSimConstraints *constrEbL);
/* subprogram name > */
char Greater705(const char *EbS, const HSimConstraints *constrEbS, const int EbU);
/* subprogram name > */
char Greater713(const int Ec0, const char *Ec2, const HSimConstraints *constrEc2);
/* subprogram name >= */
char GreaterEqual721(const char *Ec8, const HSimConstraints *constrEc8, const char *Eca, const HSimConstraints *constrEca);
/* subprogram name >= */
char GreaterEqual729(const char *Ecg, const HSimConstraints *constrEcg, const char *Eci, const HSimConstraints *constrEci);
/* subprogram name >= */
char GreaterEqual737(const char *Ecq, const HSimConstraints *constrEcq, const char *Ecs, const HSimConstraints *constrEcs);
/* subprogram name >= */
char GreaterEqual745(const char *Ecy, const HSimConstraints *constrEcy, const char *EcA, const HSimConstraints *constrEcA);
/* subprogram name >= */
char GreaterEqual753(const char *EcG, const HSimConstraints *constrEcG, const int EcI);
/* subprogram name >= */
char GreaterEqual761(const int EcP, const char *EcR, const HSimConstraints *constrEcR);
/* subprogram name >= */
char GreaterEqual769(const char *EcX, const HSimConstraints *constrEcX, const int EcZ);
/* subprogram name >= */
char GreaterEqual777(const int Ed5, const char *Ed7, const HSimConstraints *constrEd7);
/* subprogram name = */
char Equal785(const char *Edd, const HSimConstraints *constrEdd, const char *Edf, const HSimConstraints *constrEdf);
/* subprogram name = */
char Equal793(const char *Edm, const HSimConstraints *constrEdm, const char *Edp, const HSimConstraints *constrEdp);
/* subprogram name = */
char Equal801(const char *Edv, const HSimConstraints *constrEdv, const char *Edx, const HSimConstraints *constrEdx);
/* subprogram name = */
char Equal809(const char *EdD, const HSimConstraints *constrEdD, const char *EdF, const HSimConstraints *constrEdF);
/* subprogram name = */
char Equal817(const char *EdL, const HSimConstraints *constrEdL, const int EdN);
/* subprogram name = */
char Equal825(const int EdU, const char *EdW, const HSimConstraints *constrEdW);
/* subprogram name = */
char Equal833(const char *Ee2, const HSimConstraints *constrEe2, const int Ee4);
/* subprogram name = */
char Equal841(const int Eea, const char *Eec, const HSimConstraints *constrEec);
/* subprogram name /= */
char notEqual849(const char *Eei, const HSimConstraints *constrEei, const char *Eek, const HSimConstraints *constrEek);
/* subprogram name /= */
char notEqual857(const char *Ees, const HSimConstraints *constrEes, const char *Eeu, const HSimConstraints *constrEeu);
/* subprogram name /= */
char notEqual865(const char *EeA, const HSimConstraints *constrEeA, const char *EeC, const HSimConstraints *constrEeC);
/* subprogram name /= */
char notEqual873(const char *EeI, const HSimConstraints *constrEeI, const char *EeK, const HSimConstraints *constrEeK);
/* subprogram name /= */
char notEqual881(const char *EeR, const HSimConstraints *constrEeR, const int EeT);
/* subprogram name /= */
char notEqual889(const int EeZ, const char *Ef1, const HSimConstraints *constrEf1);
/* subprogram name /= */
char notEqual897(const char *Ef7, const HSimConstraints *constrEf7, const int Ef9);
/* subprogram name /= */
char notEqual905(const int Eff, const char *Efh, const HSimConstraints *constrEfh);
/* subprogram name SHL */
char *Gfu(HSimConstraints *reConstr, const char *Efp, const HSimConstraints *constrEfp, const char *Efr, const HSimConstraints *constrEfr);
/* subprogram name SHL */
char *GfC(HSimConstraints *reConstr, const char *Efx, const HSimConstraints *constrEfx, const char *Efz, const HSimConstraints *constrEfz);
/* subprogram name SHR */
char *GfK(HSimConstraints *reConstr, const char *EfF, const HSimConstraints *constrEfF, const char *EfH, const HSimConstraints *constrEfH);
/* subprogram name SHR */
char *GfT(HSimConstraints *reConstr, const char *EfN, const HSimConstraints *constrEfN, const char *EfQ, const HSimConstraints *constrEfQ);
/* subprogram name CONV_INTEGER */
int GfZ(const int EfW);
/* subprogram name CONV_INTEGER */
int Gg5(const char *Eg2, const HSimConstraints *constrEg2);
/* subprogram name CONV_INTEGER */
int Ggb(const char *Eg8, const HSimConstraints *constrEg8);
/* subprogram name CONV_INTEGER */
int Ggh(const char Ege);
/* subprogram name CONV_UNSIGNED */
char *Ggr(HSimConstraints *reConstr, const int Egk, const int Egn);
/* subprogram name CONV_UNSIGNED */
char *Ggz(HSimConstraints *reConstr, const char *Egu, const HSimConstraints *constrEgu, const int Egw);
/* subprogram name CONV_UNSIGNED */
char *GgH(HSimConstraints *reConstr, const char *EgC, const HSimConstraints *constrEgC, const int EgE);
/* subprogram name CONV_UNSIGNED */
char *GgQ(HSimConstraints *reConstr, const char EgK, const int EgM);
/* subprogram name CONV_SIGNED */
char *GgY(HSimConstraints *reConstr, const int EgT, const int EgV);
/* subprogram name CONV_SIGNED */
char *Gh6(HSimConstraints *reConstr, const char *Eh1, const HSimConstraints *constrEh1, const int Eh3);
/* subprogram name CONV_SIGNED */
char *Ghe(HSimConstraints *reConstr, const char *Eh9, const HSimConstraints *constrEh9, const int Ehb);
/* subprogram name CONV_SIGNED */
char *Ghn(HSimConstraints *reConstr, const char Ehh, const int Ehj);
/* subprogram name CONV_STD_LOGIC_VECTOR */
char *Ghw(HSimConstraints *reConstr, const int Ehr, const int Eht);
/* subprogram name CONV_STD_LOGIC_VECTOR */
char *GhE(HSimConstraints *reConstr, const char *Ehz, const HSimConstraints *constrEhz, const int EhB);
/* subprogram name CONV_STD_LOGIC_VECTOR */
char *GhM(HSimConstraints *reConstr, const char *EhH, const HSimConstraints *constrEhH, const int EhJ);
/* subprogram name CONV_STD_LOGIC_VECTOR */
char *GhV(HSimConstraints *reConstr, const char EhQ, const int EhS);
/* subprogram name EXT */
char *Gi4(HSimConstraints *reConstr, const char *EhZ, const HSimConstraints *constrEhZ, const int Ei1);
/* subprogram name SXT */
char *Gic(HSimConstraints *reConstr, const char *Ei7, const HSimConstraints *constrEi7, const int Ei9);

public:
/* subprogram name max */
int Ff(const int Ca, const int Cc);
/* subprogram name min */
int Fx(const int Cs, const int Cu);
  HSimArrayType Tbl_typebase;
  HSimArrayType Tbl_type;
  char *t0;
HSim__s4 CT;
  HSimBitVectorType Tbl_mvl9_booleanbase;
  HSimBitVectorType Tbl_mvl9_boolean;
HSim__s4 C1f;
/* subprogram name MAKE_BINARY */
char F1w(const char C1t);
/* subprogram name MAKE_BINARY */
char *F1N(HSimConstraints *reConstr, const char *C1K, const HSimConstraints *constrC1K);
/* subprogram name MAKE_BINARY */
char *F2s(HSimConstraints *reConstr, const char *C2p, const HSimConstraints *constrC2p);
/* subprogram name MAKE_BINARY */
char *F36(HSimConstraints *reConstr, const char *C33, const HSimConstraints *constrC33);
/* subprogram name MAKE_BINARY */
char *F3K(HSimConstraints *reConstr, const char *C3H, const HSimConstraints *constrC3H);
/* subprogram name MAKE_BINARY */
char *F4q(HSimConstraints *reConstr, const char *C4m, const HSimConstraints *constrC4m);
/* subprogram name MAKE_BINARY */
char *F53(HSimConstraints *reConstr, const char *C50, const HSimConstraints *constrC50);
/* subprogram name MAKE_BINARY */
char *F5H(HSimConstraints *reConstr, const char *C5E, const HSimConstraints *constrC5E);
/* subprogram name LEFT_SIGNED_ARG */
char *F6n(HSimConstraints *reConstr, const char *C6h, const HSimConstraints *constrC6h, const char *C6j, const HSimConstraints *constrC6j);
/* subprogram name LEFT_UNSIGNED_ARG */
char *F6G(HSimConstraints *reConstr, const char *C6B, const HSimConstraints *constrC6B, const char *C6D, const HSimConstraints *constrC6D);
/* subprogram name MULT_SIGNED_ARG */
char *F6Z(HSimConstraints *reConstr, const char *C6U, const HSimConstraints *constrC6U, const char *C6W, const HSimConstraints *constrC6W);
/* subprogram name MULT_UNSIGNED_ARG */
char *F7n(HSimConstraints *reConstr, const char *C7h, const HSimConstraints *constrC7h, const char *C7j, const HSimConstraints *constrC7j);
/* subprogram name mult */
char *F7L(HSimConstraints *reConstr, const char *C7G, const HSimConstraints *constrC7G, const char *C7I, const HSimConstraints *constrC7I);
/* subprogram name mult */
char *Fa0(HSimConstraints *reConstr, const char *C9V, const HSimConstraints *constrC9V, const char *C9X, const HSimConstraints *constrC9X);
/* subprogram name minus */
char *FbA(HSimConstraints *reConstr, const char *Cbv, const HSimConstraints *constrCbv, const char *Cbx, const HSimConstraints *constrCbx);
/* subprogram name plus */
char *Fd2(HSimConstraints *reConstr, const char *CcX, const HSimConstraints *constrCcX, const char *CcZ, const HSimConstraints *constrCcZ);
/* subprogram name unsigned_minus */
char *Fem(HSimConstraints *reConstr, const char *Ceg, const HSimConstraints *constrCeg, const char *Cei, const HSimConstraints *constrCei);
/* subprogram name unsigned_plus */
char *FfP(HSimConstraints *reConstr, const char *CfJ, const HSimConstraints *constrCfJ, const char *CfL, const HSimConstraints *constrCfL);
/* subprogram name UNSIGNED_RETURN_BOOLEAN */
char FLW(const char *CLR, const HSimConstraints *constrCLR, const char *CLT, const HSimConstraints *constrCLT);
/* subprogram name SIGNED_RETURN_BOOLEAN */
char FM9(const char *CM4, const HSimConstraints *constrCM4, const char *CM6, const HSimConstraints *constrCM6);
/* subprogram name is_less */
char FMn(const char *CMh, const HSimConstraints *constrCMh, const char *CMj, const HSimConstraints *constrCMj);
/* subprogram name is_less_or_equal */
char FNh(const char *CNc, const HSimConstraints *constrCNc, const char *CNe, const HSimConstraints *constrCNe);
/* subprogram name unsigned_is_less */
char FP9(const char *CP4, const HSimConstraints *constrCP4, const char *CP6, const HSimConstraints *constrCP6);
/* subprogram name unsigned_is_less_or_equal */
char FPQ(const char *CPK, const HSimConstraints *constrCPK, const char *CPM, const HSimConstraints *constrCPM);
/* subprogram name bitwise_eql */
char F15s(const char *C15m, const HSimConstraints *constrC15m, const char *C15p, const HSimConstraints *constrC15p);
/* subprogram name bitwise_neq */
char F15Q(const char *C15K, const HSimConstraints *constrC15K, const char *C15M, const HSimConstraints *constrC15M);

public:
  Xilinxcorelib_iputils_std_logic_arith(const HSimString &name);
  ~Xilinxcorelib_iputils_std_logic_arith();
};

extern Xilinxcorelib_iputils_std_logic_arith *XilinxcorelibIputils_std_logic_arith;

#endif
