LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;

--LIBRARY sercon;
USE work.sercon_types.all;


entity sercon_block is

  generic(
    -- note: ensure n_regs >=2
    n_regs:natural:=3;
    bit_width:natural:=sercon_bit_width
    );

  port(
    ctrl: in sercon_ctrl;
    --
    sbus_in: in sercon_bus;
    sbus_out: out sercon_bus;
    
    --
    -- parallel data output/input.
    pdout: out long_word_array(n_regs-1 downto 0)
    );

end entity sercon_block;

architecture v0 of sercon_block is

  
  component sercon_reg is
                         
  generic(
    reset_value:integer;
    bit_width:natural
    );
  port(
    ctrl: in sercon_ctrl;
    --
    sbus_in: in sercon_bus;
    sbus_out: out sercon_bus;
    
    pdout: out std_logic_vector(bit_width-1 downto 0);
    pdin: in std_logic_vector(bit_width-1 downto 0):=(others=>'0')

    );
  end component sercon_reg;

  signal int_pdout: long_word_array(n_regs-1 downto 0);
  
  signal int_sbus: sercon_bus_array(n_regs-1 downto 0);
  
begin
  pdout<=int_pdout;
  
  gen_rarray:for i in 0 to (n_regs-1) generate
    
    u_reg0:if(i=0) generate 
      u_idx0:sercon_reg
        generic map(
          reset_value=>0,
          bit_width=>bit_width
          )
        port map(
          ctrl => ctrl,
          sbus_in => sbus_in,
          sbus_out =>int_sbus(0),
          pdout => int_pdout(0),
          pdin => int_pdout(0)
          );
    end generate u_reg0;
    
    u_regs:if(i>0 and i<(n_regs)) generate
      u_idx:sercon_reg
        generic map(
          reset_value=>0,
          bit_width=>bit_width
          )
        port map(
          ctrl => ctrl,
          sbus_in =>int_sbus(i-1),
          sbus_out =>int_sbus(i),
          pdout => int_pdout(i),
          pdin => int_pdout(i)
          );
    end generate u_regs;
    
  end generate gen_rarray;

  sbus_out<=int_sbus(n_regs-1);
  
end architecture v0;



