library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

use work.sercon_types.all;

entity sercon_info is
  port(
    ctrl: in sercon_ctrl;
    sbus_in: in sercon_bus;
    sbus_out: out sercon_bus
    );
end entity sercon_info;

architecture v0 of sercon_info is
  component sercon_stat 
    generic(
      bit_width:natural:=32
      );
    port(
      ctrl: in sercon_ctrl;
      --
      sbus_in: in sercon_bus;
      sbus_out: out sercon_bus;

      -- parallel data input.
      pdin: in std_logic_vector(bit_width-1 downto 0)
      );
  end component sercon_stat;

  component build_time
    port(
      build_utc_output: out std_logic_vector(31 downto 0)
      );  
  end component build_time;
  component version     
    port(
      rev_output: out std_logic_vector(31 downto 0)
      );
  end component version;
  
  signal int_bus:sercon_bus;
  signal int_utc:std_logic_vector(31 downto 0);
  signal int_version:std_logic_vector(31 downto 0);
begin
  u_utc_readout:sercon_stat
    generic map(
      bit_width=>32)
    port map(
      ctrl => ctrl,
      sbus_in => sbus_in,
      sbus_out => int_bus,
      pdin => int_utc
      );

  u_version_readout:sercon_stat
    generic map (bit_width => 32)
    port map (
      ctrl => ctrl,
      sbus_in => int_bus,
      sbus_out => sbus_out,
      pdin => int_version
      );

  u_utc:build_time
    port map (build_utc_output => int_utc);

  u_version:version
    port map(rev_output => int_version);
  
end architecture v0;
