----------------------------------------------------------------------------------
-- Company: University of Oxford
-- Engineer: Rui Gao
-- 
-- Create Date:    10:02:17 03/03/2010 
-- Design Name: 
-- Module Name:    TLU_FSM_pre - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: This module performce a trigger number handshake with the EUDET TLU
--					 this module uses a slow trigger clockswitched by the FSM not clock mux 
--						Added 16 x 32-bit output fifo		
--						Added buffer reset control from the FSM
--					   Added Spill_start and Spill_active control, FIFO rests when Spill_start is high and Spillactive is low, TLU trigger numberh andshake is act when both Spill_startt and Spill active is high, when spill_start goes low, this unit will do a simple hand shake with TLU to make shure it is not blocked. 
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;

USE work.sercon_types.all;

entity TLU_FSM_pre is

     
  port(
	-- System I/Os
	 rst : in std_logic;
    clk: in std_logic;
	 Spill_start: in std_logic;	 
	 Spill_active: in std_logic;
	 timestamp_in: in std_logic_vector(12 downto 0);
	
	     	 
	 -- SERCON interface I/Os
	 TrigData_out: out std_logic_vector(31 downto 0);			 
	 sercon_load: in std_logic;
	 TrigNum_Ready_Out: out std_logic;	 
	 	 
	 --TLU I/Os
	 TLU_trigger_in: in std_logic;
	 TLU_rst_in: in std_logic;
	 TLU_busy_out: out std_logic;
	 TLU_tirg_clk_out: out std_logic; -- output clock need to be in 1 - 10Mhz range
	 
	 --Debug outputs (can be removed)
	 TrigData_out_rt: out std_logic_vector(31 downto 0);	
	 FIFO_empty: out std_logic;
	 FIFO_busy: out std_logic;
	 debug: out std_logic_vector(3 downto 0)
	 	 
	 );
  
  
end entity TLU_FSM_pre;

architecture v0 of TLU_FSM_pre is

	
   
	type status_type is ( sInt, sReady, sTrigger, sTrigClkHigh1, sTrigClkHigh2, sTrigClkLow1, sTrigClkLow2, sWrBuf, sTrigComplete, sPreFetch);
	signal CS : status_type;
	
	signal TLU_busy : std_logic;
	signal TLU_tirg_clk: std_logic;

	signal Counter: std_logic_vector(3 downto 0);
	signal delay: std_logic_vector(3 downto 0);
	
	signal TrigNum_reg: std_logic_vector (15 downto 0);
	signal TrigData: std_logic_vector (31 downto 0);
	
	signal Buf_TrigData: std_logic_vector (31 downto 0);


	signal TrigNum_Ready: std_logic;
	
	signal timestamp: std_logic_vector(12 downto 0);
	signal trig_timestamp: std_logic_vector(12 downto 0);
	
	signal buf_wr_en: std_logic;
	signal buf_rd_en: std_logic;
	signal buf_full: std_logic;
	signal buf_empty: std_logic;
	
	signal buf_rst: std_logic;
	
	
	
	
	component tlu_data_buf IS
		port (
		clk: IN std_logic;
		din: IN std_logic_VECTOR(31 downto 0);
		rd_en: IN std_logic;
		rst: IN std_logic;
		wr_en: IN std_logic;
		dout: OUT std_logic_VECTOR(31 downto 0);
		empty: OUT std_logic;
		full: OUT std_logic);
	END component tlu_data_buf;
	
	
	begin

		TrigNum_Ready_Out <= TrigNum_Ready;
		TLU_busy_out <= TLU_busy;
		TLU_tirg_clk_out <= TLU_tirg_clk;
		
		
		TrigData(31 downto 29) <= "000";
		TrigData(28 downto 16) <= trig_timestamp;
		TrigData(15 downto 0)<= TrigNum_reg;
		
		TrigData_out_rt <= TrigData;
		fifo_busy <= buf_wr_en;
		debug (3) <= Spill_start;
		debug (2) <= Spill_active;
		--debug (3 downto 2) <= trig_timestamp (12 downto 11);
		--debug (1 downto 0) <= timestamp (12 downto 11);
		
		fifo_empty <= buf_empty;
		

handshake: process (rst, clk, TLU_trigger_in, spill_active, spill_start ) 
	begin
		if (rst = '1')  then
			CS <= sInt;	
		--	debug <= "0011";
			
	 						
        elsif (clk'event and clk = '1') then
		--	debug <= TrigNum_reg (3 downto 0);
			
       	case CS is 
       	
			
				--------- Initialisation--------------
				when sInt =>
				
						TLU_busy <= '0';
						TLU_tirg_clk <= '0';
						TrigNum_reg<= x"0000";
						counter <= "1111";
						TrigNum_Ready <= '0';
				--		debug (3 downto 2) <="11";
						trig_timestamp <= "0000000000000";
						buf_wr_en <= '0';
						buf_rst <= '1';
						
						delay <= "1111";
					   debug (1 downto 0) <= "11";
						CS <= sReady; 
						
						
					when sReady => -- ready to recieve trigger
						TLU_tirg_clk <= '0';
						TrigNum_reg<= TrigNum_reg;
						counter <= "1111";
						TrigNum_Ready <= '0';
						buf_wr_en <= '0';
						
						if spill_active = '0' then
								TLU_busy <= '1';
								trig_timestamp <= trig_timestamp ;							
								buf_rst <= '0';
								debug (1 downto 0) <= "01";
								
								CS <= sTrigComplete;
								
								
						elsif TLU_trigger_in = '1' then
								TLU_busy <= '1';
								trig_timestamp <= timestamp_in ;		
								buf_rst <= '0';
								
								CS <= sTrigger;
							
						else
								TLU_busy <= '0';
								trig_timestamp <= trig_timestamp;
								buf_rst <= '0';
								
								CS <= sReady;
							
						end if;
					
						
	  
--				when sReady => -- ready to recieve trigger
--						TLU_tirg_clk <= '0';
--						TrigNum_reg<= TrigNum_reg;
--						counter <= "1111";
--						TrigNum_Ready <= '0';
--						buf_wr_en <= '0';
--						
--						if spill_start = '1' then
--							if spill_active = '0' then -- RESET FIFO
--								TLU_busy <= '0';
--								trig_timestamp <= trig_timestamp;--timestamp_in ;	
--								buf_rst <= '1';
--								CS <= sReady;
--								
--							elsif TLU_trigger_in = '1' then
--									TLU_busy <= '0';
--									trig_timestamp <= timestamp_in ;	
--									buf_rst <= '0';								
--									CS <= sTrigger;
--									
--							else
--									buf_rst <= '0';
--									TLU_busy <= '0';
--									trig_timestamp <= trig_timestamp;
--									CS <= sReady;
--									
--							end if;
--								
--						elsif 
--						   TLU_trigger_in = '1' then -- respond TLU with busy then drop it in sComplete, does not block TLU
--							TLU_busy <= '1';
--							trig_timestamp <= trig_timestamp;
--							buf_rst <= buf_rst;
--							CS <= sTrigComplete;
--						else
--							TLU_busy <= '0';
--							trig_timestamp <= trig_timestamp;
--							buf_rst <= buf_rst;
--							CS <= sReady;
--						
--						end if;
						
							

----------------sReady before adding spill active control						
--					when sReady => -- ready to recieve trigger
--						TLU_tirg_clk <= '0';
--						TrigNum_reg<= TrigNum_reg;
--						counter <= "1111";
--						TrigNum_Ready <= '0';
--						buf_wr_en <= '0';
--						if TLU_trigger_in = '1' then
--							TLU_busy <= '1';
--							trig_timestamp <= timestamp ;							
--							CS <= sTrigger;
--							
--						else
--							TLU_busy <= '0';
--							trig_timestamp <= trig_timestamp;
--							CS <= sReady;
--							
--						end if;
						
				when sTrigger =>
						TLU_busy <= '1';	
						TLU_tirg_clk <= '0';
						TrigNum_reg<= TrigNum_reg;
						counter <= counter;
						TrigNum_Ready <= '0';
						
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						buf_rst <= '0';
						
						if TLU_trigger_in = '1' then
							CS <= sTrigger;
						else
							CS <= sTrigClkHigh1;
						end if;

				when sTrigClkHigh1 => -- incoming trigger, reply with "busy"
						
						--	debug (3 downto 2) <="01";
							TLU_busy <= '1';
							TLU_tirg_clk <= '1';
							TrigNum_reg <= TrigNum_reg;
							TrigNum_Ready <= '0';
							counter <= counter + 1;
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							delay <= delay + 1;
							buf_rst <= buf_rst;
							
							
							CS <= sTrigClkHigh2;
					
							
				when sTrigClkHigh2 => -- incoming trigger, reply with "busy"
						
						--	debug (3 downto 2) <="01";
							TLU_busy <= '1';
							TLU_tirg_clk <= '1';
							TrigNum_reg <= TrigNum_reg;
							TrigNum_Ready <= '0';
							counter <= counter;
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							delay <= delay + 1;
							buf_rst <= buf_rst;
							
							if delay = "1111" then
								CS <= sTrigClkLow1;
							else
								CS <= sTrigClkHigh2;
							end if;
							
					When sTrigClkLow1 =>
						TLU_busy <= '1';
						TLU_tirg_clk <= '0';
						TrigNum_reg <=  TLU_trigger_in & TrigNum_reg(15 downto 1);
						counter <= counter;
						--TrigNum_reg <= TrigNum_reg;
						
						TrigNum_Ready <= '0';
					--	debug (3 downto 2) <="00";
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						delay <= delay + 1;
						buf_rst <= buf_rst;
						
						CS <= sTrigClkLow2;	
						
					When sTrigClkLow2 =>
						TLU_busy <= '1';
						TLU_tirg_clk <= '0';
					--	TrigNum_reg <=  TLU_trigger_in & TrigNum_reg(15 downto 1);
						counter <= counter;
						TrigNum_reg <= TrigNum_reg;
						TrigNum_Ready <= '0';
					--	debug (3 downto 2) <="00";
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						delay <= delay + 1;
						buf_rst <= buf_rst;
						
						if delay = "1111" then
							if counter = "1111" then
								CS <= sWrBuf;
							else 
								CS <= sTrigClkHigh1;							
							end if;
						else
							CS <=  sTrigClkLow2;
							
						end if;

				when sWrBuf => -- this state will NOT block the TLU trigger if FIFO is full, will cause FIFO over flow 
							
								TLU_busy <= '0';
								TLU_tirg_clk <= '0';
								TrigNum_Ready <= '1';
								TrigNum_reg <= TrigNum_reg;
								counter <= counter;
							--	debug (3 downto 2) <="00";
								trig_timestamp <= trig_timestamp;
								buf_wr_en <= '1';
								buf_rst <= buf_rst;
								
		
								CS <= sTrigComplete;

						
--				when sWrBuf => -- this state will block the TLU trigger if FIFO is full!!
--							if buf_full = '0' then
--							
--								TLU_busy <= '0';
--								TLU_tirg_clk <= '0';
--								TrigNum_Ready <= '1';
--								TrigNum_reg <= TrigNum_reg;
--								counter <= counter;
--							--	debug (3 downto 2) <="00";
--								trig_timestamp <= trig_timestamp;
--								buf_wr_en <= '1';
--								
--		
--								CS <= sTrigComplete;
--							else
--								TLU_busy <= '0';
--								TLU_tirg_clk <= '0';
--								TrigNum_Ready <= '1';
--								TrigNum_reg <= TrigNum_reg;
--								counter <= counter;
--							--	debug (3 downto 2) <="00";
--								trig_timestamp <= trig_timestamp;
--								buf_wr_en <= '0';
--								
--								CS <= sWrBuf;
--							end if;
							
				when sTrigComplete => -- Tirgger Handshake complete, flag TrigNum_Ready high
				
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							TrigNum_Ready <= '1';
							TrigNum_reg <= TrigNum_reg;
							counter <= counter;
						--	debug (3 downto 2) <="00";
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							buf_rst <= buf_rst;
							debug (1 downto 0) <= "10";
					
							if spill_active = '0' then
								CS <= sPreFetch;
							else
								CS <= sReady;
							end if

	when sPreFetch => -- this state will NOT block the TLU trigger if FIFO is full, will cause FIFO over flow 
							
								TLU_busy <= '0';
								TLU_tirg_clk <= '0';
								TrigNum_Ready <= '1';
								TrigNum_reg <= TrigNum_reg;
								counter <= counter;
							--	debug (3 downto 2) <="00";
								trig_timestamp <= trig_timestamp;
								buf_wr_en <= '0';
								buf_rst <= buf_rst;
								buf_rd_en <= '1';
								
								if buf_empty = '0' then
									DataOut<= DataOut;
									CS <= sReadData;
								else
								   DataOut<= DataOut;
									CS <= sReadData;
								end if;
								
									

	when sReadData => -- this state will NOT block the TLU trigger if FIFO is full, will cause FIFO over flow 
							
								TLU_busy <= '0';
								TLU_tirg_clk <= '0';
								TrigNum_Ready <= '1';
								TrigNum_reg <= TrigNum_reg;
								counter <= counter;
							--	debug (3 downto 2) <="00";
								trig_timestamp <= trig_timestamp;
								buf_wr_en <= '0';
								buf_rst <= buf_rst;
								buf_rd_en <= '0';
								DataOut <= buf_data_out;
										
								CS <= sWaitSERCON;


	when sWaitSERCON => -- this state will NOT block the TLU trigger if FIFO is full, will cause FIFO over flow 
							
								TLU_busy <= '0';
								TLU_tirg_clk <= '0';
								TrigNum_Ready <= '1';
								TrigNum_reg <= TrigNum_reg;
								counter <= counter;
							--	debug (3 downto 2) <="00";
								trig_timestamp <= trig_timestamp;
								buf_wr_en <= '0';
								buf_rst <= buf_rst;
								buf_rd_en <= '0';
								DataOut <= DataOut;
								if sercon_load = '1' then
									CS <= sPreFetch;

								else
									CS <= sWaitSERCON
									
								end if;
								




						
				when others =>
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							TrigNum_Ready <= '0';
							TrigNum_reg <= TrigNum_reg;
							counter <= counter;
						--	debug (3 downto 2) <="00";
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							buf_rst <= buf_rst;
							
							CS <= sReady;
				
			end case;
		
	end if;	
	
end process;

outputmux: process (buf_empty)
begin
	if (buf_empty = '0')  then
			TrigData_out <= Buf_TrigData;
	else 
			TrigData_out <= "11100000000000001000000000000000";
	end if;
end process outputmux;


outbuf: tlu_data_buf_FWFT
		port map(
		clk => clk,
		din => TrigData,
		rd_en => buf_rd_en, --sercon_load, 
		rst => rst, --buf_rst,
		wr_en => buf_wr_en,
		dout => buf_data_out, --Buf_TrigData,
		empty => buf_empty,
		full => buf_full );


end architecture v0;

