----------------------------------------------------------------------------------
-- Company: University of Oxford
-- Engineer: Rui Gao
-- 
-- Create Date:    15:02:17 01/25/2010 
-- Design Name: 
-- Module Name:    TLU_FSM_slow_slow - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: This module performce a trigger number handshake with the EUDET TLU
--					 this module uses a slow trigger clockswitched by the FSM not clock mux 
--						Added 16 x 32-bit output fifo		
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;

USE work.sercon_types.all;

entity TLU_FSM_slow is

     
  port(
	-- system inputs
	 rst : in std_logic;
    clk_in: in std_logic; 
	 debug: out std_logic_vector(3 downto 0);	 
	 rst_ts: in std_logic;
	 
    --Inputs from TLU 
	 TLU_trigger_in: in std_logic;
	 TLU_rst_in: in std_logic;
        	 
	 -- SERCON interface
	 TrigData_out: out std_logic_vector(31 downto 0);			 
	 TrigData_out_rt: out std_logic_vector(31 downto 0);	
	 FIFO_empty: out std_logic;
	 FIFO_busy: out std_logic;
	-- FIFO_rd_en: in std_logic;
	 sercon_load: in std_logic;
	 spill_active: in std_logic;
	 
	 TrigNum_Ready_Out: out std_logic;	 
	 -- signals to TLU
	 TLU_busy_out: out std_logic;
	 TLU_tirg_clk_out: out std_logic -- output clock need to be in 1 - 100Mhz range
	 );
  
  
end entity TLU_FSM_slow;

-- generate slow clock
architecture v0 of TLU_FSM_slow is

	
   
	type status_type is ( sInt, sReady ,sReturn, sTrigger, sTrigClkHigh1, sTrigClkHigh2, sTrigClkLow1, sTrigClkLow2,sWrBuf, sTrigComplete);
	signal CS : status_type;
	
	signal TLU_busy : std_logic;
	signal TLU_tirg_clk: std_logic;

	signal Counter: std_logic_vector(3 downto 0);
	signal delay: std_logic_vector(3 downto 0);
	
	signal TrigNum_reg: std_logic_vector (15 downto 0);
	signal TrigData: std_logic_vector (31 downto 0);
	signal TrigData_rt: std_logic_vector (31 downto 0);
	
	signal LatchTrigData: std_logic_vector (31 downto 0);


	signal TrigNumReady_flag: std_logic;
	
	signal timestamp: std_logic_vector(12 downto 0);
	signal trig_timestamp: std_logic_vector(12 downto 0);
	
	signal buf_wr_en: std_logic;
	signal buf_rd_en: std_logic;
	signal buf_full: std_logic;
	signal buf_empty: std_logic;
	
	
	
	--signal buf_din: std_logic_vector(31 downto 0);
	
	
	
	component TLU_data_buf_FWFT IS
		port (
		clk: IN std_logic;
		din: IN std_logic_VECTOR(31 downto 0);
		rd_en: IN std_logic;
		rst: IN std_logic;
		wr_en: IN std_logic;
		dout: OUT std_logic_VECTOR(31 downto 0);
		empty: OUT std_logic;
		full: OUT std_logic);
	END component TLU_data_buf_FWFT;
	
	
	component TLU_output_latch is

	  port(
		-- system inputs
		 rst : in std_logic;
		 clk_in: in std_logic; 
		 debug: out std_logic_vector(3 downto 0);	 
		 
		 --Inputs TLU FSM interface
		 TLU_Data_in: in std_logic_vector(31 downto 0);		
		 fifo_rd_out: out std_logic;
		 fifo_empty: in std_logic;
		 fifo_busy: in std_logic;
		 
		 -- SERCON interface 
		 TLU_Data_out: out std_logic_vector(31 downto 0);		
		 sercon_load: in std_logic 
		 
			 
		 );
	  
  
end component TLU_output_latch;


	
	
	begin

		TrigNum_Ready_Out <= TrigNumReady_flag;
		TLU_busy_out <= TLU_busy;
		TLU_tirg_clk_out <= TLU_tirg_clk;
		
		-- Trigger Data 31-29 bits -000, 29-16 bits timestamp, 15 - 0 trigger number (bit 15 always 0)
		TrigData(31 downto 29) <= "000";
		TrigData(28 downto 16) <= "0000000000000";--trig_timestamp;
		TrigData(15 downto 0)<= TrigNum_reg;
		
		TrigData_out_rt <= TrigData;
		
		fifo_empty <= buf_empty;
		fifo_busy <= buf_wr_en;
		

		
handshake: process (rst, clk_in, TLU_trigger_in ) 
	begin
		if (rst = '1')  then
			CS <= sInt;	
		--	debug <= "0000";
			
	 						
        elsif (clk_in'event and clk_in = '1') then
		--	debug <= TrigNum_reg (3 downto 0);
			
       	case CS is 
       	
			
				--------- Initialisation--------------
				when sInt =>
				
						TLU_busy <= '0';
						TLU_tirg_clk <= '0';
						TrigNum_reg<= x"0000";
						counter <= "1111";
						TrigNumReady_flag <= '0';
				--		debug (3 downto 2) <="11";
						trig_timestamp <= "0000000000000";
						buf_wr_en <= '0';
						
						delay <= "1111";
					
						CS <= sReady; 
	  	  
				when sReady => -- ready to recieve trigger
						TLU_tirg_clk <= '0';
						TrigNum_reg<= TrigNum_reg;
						counter <= "1111";
						TrigNumReady_flag <= '0';
						buf_wr_en <= '0';
						if spill_active = '1' then
							if TLU_trigger_in = '1' then
								TLU_busy <= '1';
								trig_timestamp <= timestamp ;							
								CS <= sTrigger;
								
							else
								TLU_busy <= '0';
								trig_timestamp <= trig_timestamp;
								CS <= sReady;
								
							end if;
						else
								TLU_busy <= '1';
								trig_timestamp <= trig_timestamp ;							
								CS <= sTrigComplete;
						end if;
						
						
				when sTrigger =>
						TLU_busy <= '1';	
						TLU_tirg_clk <= '0';
						TrigNum_reg<= TrigNum_reg;
						counter <= counter;
						TrigNumReady_flag <= '0';
						
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						
						if TLU_trigger_in = '1' then
							CS <= sTrigger;
						else
							CS <= sTrigClkHigh1;
						end if;

				when sTrigClkHigh1 => -- incoming trigger, reply with "busy"
						
						--	debug (3 downto 2) <="01";
							TLU_busy <= '1';
							TLU_tirg_clk <= '1';
							TrigNum_reg <= TrigNum_reg;
							TrigNumReady_flag <= '0';
							counter <= counter + 1;
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							delay <= delay + 1;
							
							
							CS <= sTrigClkHigh2;
					
							
				when sTrigClkHigh2 => -- incoming trigger, reply with "busy"
						
						--	debug (3 downto 2) <="01";
							TLU_busy <= '1';
							TLU_tirg_clk <= '1';
							TrigNum_reg <= TrigNum_reg;
							TrigNumReady_flag <= '0';
							counter <= counter;
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							delay <= delay + 1;
							
							if delay = "1111" then
								CS <= sTrigClkLow1;
							else
								CS <= sTrigClkHigh2;
							end if;
							
					When sTrigClkLow1 =>
						TLU_busy <= '1';
						TLU_tirg_clk <= '0';
						TrigNum_reg <=  TLU_trigger_in & TrigNum_reg(15 downto 1);
						counter <= counter;
						--TrigNum_reg <= TrigNum_reg;
						
						TrigNumReady_flag <= '0';
					--	debug (3 downto 2) <="00";
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						delay <= delay + 1;
						
						CS <= sTrigClkLow2;	
						
					When sTrigClkLow2 =>
						TLU_busy <= '1';
						TLU_tirg_clk <= '0';
					--	TrigNum_reg <=  TLU_trigger_in & TrigNum_reg(15 downto 1);
						counter <= counter;
						TrigNum_reg <= TrigNum_reg;
						TrigNumReady_flag <= '0';
					--	debug (3 downto 2) <="00";
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						delay <= delay + 1;
						
						if delay = "1111" then
							if counter = "1111" then
								CS <= sWrBuf;
							else 
								CS <= sTrigClkHigh1;							
							end if;
						else
							CS <=  sTrigClkLow2;
							
						end if;

	
						
				when sWrBuf =>
							if buf_full = '0' then
							
								TLU_busy <= '0';
								TLU_tirg_clk <= '0';
								TrigNumReady_flag <= '1';
								TrigNum_reg <= TrigNum_reg;
								counter <= counter;
							--	debug (3 downto 2) <="00";
								trig_timestamp <= trig_timestamp;
								buf_wr_en <= '1';
								
		
								CS <= sTrigComplete;
							else
								TLU_busy <= '0';
								TLU_tirg_clk <= '0';
								TrigNumReady_flag <= '1';
								TrigNum_reg <= TrigNum_reg;
								counter <= counter;
							--	debug (3 downto 2) <="00";
								trig_timestamp <= trig_timestamp;
								buf_wr_en <= '0';
								
								CS <= sWrBuf;
							end if;
							
				when sTrigComplete => -- Tirgger Handshake complete, flag TrigNumReady_flag high
				
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							TrigNumReady_flag <= '1';
							TrigNum_reg <= TrigNum_reg;
							counter <= counter;
						--	debug (3 downto 2) <="00";
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
					
						   CS <= sReady;
						
				when others =>
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							TrigNumReady_flag <= '0';
							TrigNum_reg <= TrigNum_reg;
							counter <= counter;
						--	debug (3 downto 2) <="00";
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							
							CS <= sReady;
				
			end case;
		
	end if;	
	
end process;

time_counter: process (clk_in,rst_ts)
begin
	if (rst_ts = '1')  then
			timestamp <= "0000000000000";
	elsif (clk_in'event and clk_in = '1') then
			timestamp <= timestamp + 1;
	end if;
end process time_counter;


outbuf: TLU_data_buf_FWFT
		port map(
		clk => clk_in,
		din => TrigData,
		rd_en => sercon_load, --buf_rd_en,
		rst => rst,
		wr_en => buf_wr_en,
		dout => TrigData_out, --LatchTrigData,
		empty => buf_empty,
		full => buf_full );

--latch: TLU_output_latch 
--
--  port map(
--	-- system inputs
--	 rst => rst,
--    clk_in => clk_in,
--	 debug => debug,
--	 
--    --Inputs TLU FSM interface
--	 TLU_Data_in => LatchTrigData,
--	 fifo_rd_out => buf_rd_en,
--	 fifo_empty => buf_empty,
--	 fifo_busy => buf_wr_en,
--	 
--	 -- SERCON interface 
--	 TLU_Data_out => open, --TrigData_out,
--	 sercon_load => '0'); --sercon_load);
	 
	 
end architecture v0;

