----------------------------------------------------------------------------------
-- Company: University of Oxford
-- Engineer: Rui Gao
-- 
-- Create Date:    15:02:17 01/25/2010 
-- Design Name: 
-- Module Name:    TLU_FSM_slow2_slow - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: This module performce a trigger number handshake with the EUDET TLU
--					 this module uses a slow trigger clockswitched by the FSM not clock mux 
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;

USE work.sercon_types.all;

entity TLU_FSM_slow2 is

     
  port(
	 rst : in std_logic;
    clk_in: in std_logic; 
	 debug: out std_logic_vector(3 downto 0);
    
	 TLU_trigger_in: in std_logic;
	 TLU_rst_in: in std_logic;
        	 
	 TrigNum_out: out std_logic_vector(31 downto 0);		
	 TrigNum_Ready_Out: out std_logic;	 
	 TLU_busy_out: out std_logic;
	 TLU_tirg_clk_out: out std_logic -- output clock need to be in 10 - 20Mhz range
	 );
  
  
end entity TLU_FSM_slow2;

-- generate slow clock
architecture v0 of TLU_FSM_slow2 is


   
	type status_type is ( sInt, sReady ,sReturn, sTrigger, sTrigClkHigh, sTrigClkLow, sTrigComplete);
	signal CS : status_type;
	
	signal TLU_busy : std_logic;
	signal TLU_tirg_clk: std_logic;

	signal Counter: std_logic_vector(3 downto 0); 
   signal TrigNum_reg: std_logic_vector (15 downto 0);

	signal TrigNumReady_flag: std_logic;
	
	signal TN_Counter: std_logic_vector(4 downto 0);
	
	begin

		TrigNum_Ready_Out <= TrigNumReady_flag;
		TLU_busy_out <= TLU_busy;
		
		TLU_tirg_clk_out <= TLU_tirg_clk;
		--TLU_tirg_clk_out <= clk_in;
		TrigNum_out(31 downto 16) <= x"0000";
		TrigNum_out(15 downto 0)<= TrigNum_reg;
		
	--	debug (3) <= TLU_busy;
   --	debug (2) <= counter(4);
	--	debug (1) <= TLU_busy;
	--	debug (0) <= TLU_trigger_in;
	--	debug (1 downto 0 ) <= counter (3 downto 2);
		
handshake: process (rst, clk_in, TLU_trigger_in ) 
	begin
		if (rst = '1')  then
			CS <= sInt;	
			debug <= "0000";
		--	debug (3 downto 2) <= "11";
	 						
        elsif (clk_in'event and clk_in = '1') then
			debug <= TrigNum_reg (15 downto 12);
			
       	case CS is 
       	
			
				--------- Initialisation--------------
				when sInt =>
				
						TLU_busy <= '0';
						TLU_tirg_clk <= '0';
						TrigNum_reg<= x"0000";
						counter <= "1111";
						TrigNumReady_flag <= '0';
				--		debug (3 downto 2) <="11";
						TN_Counter <= "00000";

						CS <= sReady; 
	  	  
				when sReady => -- ready to recieve trigger
						TLU_tirg_clk <= '0';
						TrigNum_reg<= TrigNum_reg;
						counter <= "1111";
						TrigNumReady_flag <= '0';
						
						TN_Counter <= TN_Counter;
						
				
						if TLU_trigger_in = '1' then
							TLU_busy <= '1';	
							CS <= sTrigger;
							
						else
							TLU_busy <= '0';
							CS <= sReady;
							
						end if;
						
				when sTrigger =>
				
						TLU_busy <= '1';	
						TLU_tirg_clk <= '0';
						TrigNum_reg<= TrigNum_reg;
						counter <= counter;
						TrigNumReady_flag <= '0';
						
						TN_Counter <= TN_Counter;
						
						if TLU_trigger_in = '1' then
							CS <= sTrigger;
						else
							CS <= sTrigClkHigh;
						end if;
							


				when sTrigClkHigh => -- incoming trigger, reply with "busy"
						
						--	debug (3 downto 2) <="01";
							TLU_busy <= '1';
							TLU_tirg_clk <= '1';
							--TrigNum_reg <= x"0000";
						
						if counter = "1111" then
							TrigNum_reg <= TrigNum_reg;
						else
							TrigNum_reg <=  TLU_trigger_in & TrigNum_reg(15 downto 1);
						end if;
						
							TrigNumReady_flag <= '0';
							counter <= counter + 1;
							
							TN_Counter <= TN_Counter;
							
							CS <= sTrigClkLow; 
				 			
					
					When sTrigClkLow =>
						TLU_busy <= '1';
						TLU_tirg_clk <= '0';
						--TrigNum_reg <= TrigNum_reg (bit_width - 2 downto 0) & TLU_trigger_in;
						counter <= counter;
						TrigNum_reg <= TrigNum_reg;
						
						TrigNumReady_flag <= '0';
					--	debug (3 downto 2) <="00";
						TN_Counter <= TN_Counter;
						

						if counter = "1111" then

							CS <= sTrigComplete;
							
						else 

							CS <= sTrigClkHigh;
							
						end if;
						

				when sTrigComplete => -- Tirgger Handshake complete, flag TrigNumReady_flag high
				
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							TrigNumReady_flag <= '1';
							TrigNum_reg <= TrigNum_reg;
							counter <= counter;
						--	debug (3 downto 2) <="00";
							TN_Counter <= TN_Counter + 1;
	
						   CS <= sReady;
						
				when others =>
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							TrigNumReady_flag <= '0';
							TrigNum_reg <= TrigNum_reg;
							counter <= counter;
						--	debug (3 downto 2) <="00";
							TN_Counter <= TN_Counter;
							
							CS <= sReady;
				
			end case;
		
	end if;	
	
end process;

--clock_mux: process (clk_in,TLU_tirg_clk )
--begin
--	if TLU_tirg_clk = '1' then
--			TLU_tirg_clk_out <= clk_in;
--	else
--			TLU_tirg_clk_out <= '0';
--	end if;
--end process clock_mux;

			

  
end architecture v0;

