----------------------------------------------------------------------------------
-- Company: University of Oxford
-- Engineer: Rui Gao
-- 
-- Create Date:    15:02:17 01/25/2010 
-- Design Name: 
-- Module Name:    TLU_FSM_slow_slow - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: This module performce a trigger number handshake with the EUDET TLU
--					 this module uses a slow trigger clockswitched by the FSM not clock mux 
--						Added 16 x 32-bit output fifo		
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;

USE work.sercon_types.all;

entity TLU_FSM_spill is

     
  port(
	-- system inputs
	 rst : in std_logic;
    clk_in: in std_logic; 
	 debug: out std_logic_vector(3 downto 0);	 
	 rst_ts: in std_logic;
	 
    --Inputs from TLU 
	 TLU_trigger_in: in std_logic;
	 TLU_rst_in: in std_logic;
        	 
	 -- SERCON interface
	 TrigData_out: out std_logic_vector(31 downto 0);			 
	 TrigData_out_rt: out std_logic_vector(31 downto 0);	
	 FIFO_empty: out std_logic;
	 FIFO_busy: out std_logic;
	 FIFO_rst: in std_logic;
	 sercon_load: in std_logic;
	 spill_active: in std_logic;
	 timestamp_in: in std_logic_vector(12 downto 0);	
	 
	 
	 TrigNum_Ready_Out: out std_logic;	 
	 -- signals to TLU
	 TLU_busy_out: out std_logic;
	 TLU_tirg_clk_out: out std_logic -- output clock need to be in 1 - 100Mhz range
	 );
  
  
end entity TLU_FSM_spill;

-- generate slow clock
architecture v0 of TLU_FSM_spill is

	
   
	type status_type is ( sInt, sReady ,sReturn, sTrigger, sTrigClkHigh1, sTrigClkHigh2, sTrigClkLow1, sTrigClkLow2,sWrBuf,sWriteSpillEndWord, sTrigComplete);
	signal CS : status_type;
	
	signal TLU_busy : std_logic;
	signal TLU_tirg_clk: std_logic;
	signal int_TLU_trigger: std_logic;
	

	signal Counter: std_logic_vector(3 downto 0);
	signal delay: std_logic_vector(3 downto 0);
	
	signal TrigNum_reg: std_logic_vector (15 downto 0);
	signal TrigData: std_logic_vector (31 downto 0);
	signal TrigData_rt: std_logic_vector (31 downto 0);
	
	signal LatchTrigData: std_logic_vector (31 downto 0);


	signal TrigNumReady_flag: std_logic;
	
	signal int_timestamp: std_logic_vector(12 downto 0);
	signal trig_timestamp: std_logic_vector(12 downto 0);
	
	signal buf_wr_en: std_logic;
	signal buf_rd_en: std_logic;
	signal buf_full: std_logic;
	signal buf_empty: std_logic;
	signal write_en: std_logic;
	signal spill_status: std_logic;
	signal spill_end_word:std_logic_vector(2 downto 0);
	
	
	
	--signal buf_din: std_logic_vector(31 downto 0);
	
	
	
	component TLU_data_buf_FWFT IS
		port (
		clk: IN std_logic;
		din: IN std_logic_VECTOR(31 downto 0);
		rd_en: IN std_logic;
		rst: IN std_logic;
		wr_en: IN std_logic;
		dout: OUT std_logic_VECTOR(31 downto 0);
		empty: OUT std_logic;
		full: OUT std_logic);
	END component TLU_data_buf_FWFT;
	
		
	
	begin

		TrigNum_Ready_Out <= TrigNumReady_flag;
		TLU_busy_out <= TLU_busy;
		TLU_tirg_clk_out <= TLU_tirg_clk;
		
		-- Trigger Data 31-29 bits -000, 29-16 bits timestamp, 15 - 0 trigger number (bit 15 always 0)
		TrigData(31 downto 29) <= spill_end_word;--"000";-- when buf_empty = '0' else "111";
		TrigData(28 downto 16) <= trig_timestamp;
		TrigData(15 downto 0) <= TrigNum_reg;
		
		TrigData_out_rt <= TrigData;
		
		fifo_empty <= buf_empty;
		fifo_busy <= buf_wr_en;


reg_input: process (clk_in)
  begin 
    if(rising_edge(clk_in))then
	   int_TLU_trigger<= TLU_trigger_in;
      int_timestamp<=timestamp_in;

    end if;
  end process reg_input;
		
handshake: process (rst, clk_in) 
	begin
		if (rst = '1')  then
			CS <= sInt;	
		--	debug <= "0000";
			
	 						
        elsif (clk_in'event and clk_in = '1') then
		--	debug <= TrigNum_reg (3 downto 0);
			
       	case CS is 
       	
			
				--------- Initialisation--------------
				when sInt =>
				
						TLU_busy <= '0';
						TLU_tirg_clk <= '0';
						TrigNum_reg<= x"0000";
						counter <= "1111";
						TrigNumReady_flag <= '0';
				--		debug (3 downto 2) <="11";
						trig_timestamp <= "0000000000000";
						buf_wr_en <= '0';
						spill_status <= '0';
						spill_end_word <= "000";
						
						delay <= "1111";
					
						CS <= sReady; 
	  	  
				when sReady => -- ready to recieve trigger
						TLU_tirg_clk <= '0';
						TrigNum_reg<= x"0000";
						counter <= "1111";
						TrigNumReady_flag <= '0';
						buf_wr_en <= '0';
						
						if TLU_trigger_in = '1' then
							TLU_busy <= '1';
							trig_timestamp <= int_timestamp ;	-- sample timestamp	
							spill_status <= spill_active;
							CS <= sTrigger;
							
						else
							TLU_busy <= '0';
							trig_timestamp <= trig_timestamp;
							CS <= sReady;
							
						end if;
						
						
						
				when sTrigger =>
						TLU_busy <= '1';	
						TLU_tirg_clk <= '0';
						TrigNum_reg<= TrigNum_reg;
						counter <= counter;
						TrigNumReady_flag <= '0';
						
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						spill_status <= spill_status;
						
						if TLU_trigger_in = '1' then
							CS <= sTrigger;
						else
							CS <= sTrigClkHigh1;
						end if;


				when sTrigClkHigh1 => -- incoming trigger, reply with "busy"
						
						--	debug (3 downto 2) <="01";
							TLU_busy <= '1';
							TLU_tirg_clk <= '1';
							TrigNum_reg <= TrigNum_reg;
							TrigNumReady_flag <= '0';
							counter <= counter + 1;
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							delay <= delay + 1;
							spill_status <= spill_status;		
							spill_end_word <= "000";							
							delay <= "1111";
							
							CS <= sTrigClkHigh2;
					
							
				when sTrigClkHigh2 => -- incoming trigger, reply with "busy"
						
						--	debug (3 downto 2) <="01";
							TLU_busy <= '1';
							TLU_tirg_clk <= '1';
							TrigNum_reg <= TrigNum_reg;
							TrigNumReady_flag <= '0';
							counter <= counter;
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							delay <= delay + 1;
							spill_status <= spill_status;
							spill_end_word <= "000";
							
							if delay = "1111" then
								CS <= sTrigClkLow1;
							else
								CS <= sTrigClkHigh2;
							end if;
							
					When sTrigClkLow1 =>
						TLU_busy <= '1';
						TLU_tirg_clk <= '0';
						TrigNum_reg <=  TLU_trigger_in & TrigNum_reg(15 downto 1);
						counter <= counter;
						--TrigNum_reg <= TrigNum_reg;
						
						TrigNumReady_flag <= '0';
					--	debug (3 downto 2) <="00";
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						delay <= delay + 1;
						spill_status <= spill_status;
						spill_end_word <= "000";
						
						CS <= sTrigClkLow2;	
						
					When sTrigClkLow2 =>
						TLU_busy <= '1';
						TLU_tirg_clk <= '0';
					--	TrigNum_reg <=  TLU_trigger_in & TrigNum_reg(15 downto 1);
						counter <= counter;
						TrigNum_reg <= TrigNum_reg;
						TrigNumReady_flag <= '0';
					--	debug (3 downto 2) <="00";
						trig_timestamp <= trig_timestamp;
						buf_wr_en <= '0';
						delay <= delay + 1;
						spill_status <= spill_status;
						spill_end_word <= "000";
						
						if delay = "1111" then
							if counter = "1111" then
								CS <= sWrBuf;
							else 
								CS <= sTrigClkHigh1;							
							end if;
						else
							CS <=  sTrigClkLow2;
							
						end if;

	
						
				when sWrBuf =>
			--				if buf_full = '0' then
							
								TLU_busy <= '0';
								TLU_tirg_clk <= '0';
								TrigNumReady_flag <= '1';
								TrigNum_reg <= TrigNum_reg;
								counter <= counter;
							--	debug (3 downto 2) <="00";
								trig_timestamp <= trig_timestamp;
								buf_wr_en <= spill_status; 
								spill_status <= spill_status;
								spill_end_word <= "000";
									
								CS <= sTrigComplete;
--							else
--							
--								TLU_busy <= '1';
--								TLU_tirg_clk <= '0';
--								TrigNumReady_flag <= '1';
--								TrigNum_reg <= TrigNum_reg;
--								counter <= counter;
--							--	debug (3 downto 2) <="00";
--								trig_timestamp <= trig_timestamp;
--								buf_wr_en <= '0'; 
--								spill_status <= spill_status;
--								spill_end_word <= "000";
--									
--								CS <= sWrBuf;	
--							end if;
							
				when sTrigComplete => -- Tirgger Handshake complete, flag TrigNumReady_flag high
				
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							TrigNumReady_flag <= '1';
							TrigNum_reg <= TrigNum_reg;
							counter <= counter;
						--	debug (3 downto 2) <="00";
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							spill_status <= spill_status;
							
							CS <= sReady;
							
--							if spill_status = '1' then
--								if spill_active = '0' then
--									spill_end_word <= "111";
--									CS <= sWriteSpillEndWord;
--								else
--									spill_end_word <= "000";
--									CS <= sReady;
--								end if;
--							else
--								spill_end_word <= "000";
--								CS <= sReady;
--							end if;
							
						   
							
				when sWriteSpillEndWord =>
								TLU_busy <= '0';
								TLU_tirg_clk <= '0';
								TrigNumReady_flag <= '1';
								TrigNum_reg <= TrigNum_reg;
								counter <= counter;
							--	debug (3 downto 2) <="00";
								trig_timestamp <= trig_timestamp;
								buf_wr_en <= '1'; 
								spill_status <= spill_status;
								spill_end_word <= spill_end_word;
									
								CS <= sReady;
						
						
				when others =>
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							TrigNumReady_flag <= '0';
							TrigNum_reg <= TrigNum_reg;
							counter <= counter;
						--	debug (3 downto 2) <="00";
							trig_timestamp <= trig_timestamp;
							buf_wr_en <= '0';
							spill_status <= spill_status;
							
							CS <= sReady;
				
			end case;
		
	end if;	
	
end process;

--buf_rd_en <= sercon_load when spill_active = '0' and buf_wr_en = '0';
--write_en <= buf_wr_en AND spill_active; --when spill_active = '1' else '0';
--read_control: process(spill_active)
--begin
--	if spill_active = '0' then
--		if buf_wr_en = '0' then
--				buf_rd_en <= sercon_load;
--		end if;
--	end if;
--end process read_control;
			
			
outbuf: TLU_data_buf_FWFT
		port map(
		clk => clk_in,
		din => TrigData,
		rd_en => sercon_load,
		rst => FIFO_rst,
		wr_en => buf_wr_en, 
		dout => TrigData_out, 
		empty => buf_empty,
		full => buf_full );
		
debug(3)<=  sercon_load;
debug(2)<=  spill_active;
debug(1)<=  buf_wr_en;
debug(0)<=  spill_status;

		

--latch: TLU_output_latch 
--
--  port map(
--	-- system inputs
--	 rst => rst,
--    clk_in => clk_in,
--	 debug => debug,
--	 
--    --Inputs TLU FSM interface
--	 TLU_Data_in => LatchTrigData,
--	 fifo_rd_out => buf_rd_en,
--	 fifo_empty => buf_empty,
--	 fifo_busy => buf_wr_en,
--	 
--	 -- SERCON interface 
--	 TLU_Data_out => open, --TrigData_out,
--	 sercon_load => '0'); --sercon_load);
	 
	 
end architecture v0;

