----------------------------------------------------------------------------------
-- Company: University of Oxford
-- Engineer: Rui Gao
-- 
-- Create Date:    15:02:17 01/25/2010 
-- Design Name: 
-- Module Name:    TLU_output_latch - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: This module interface between the TLU buffer and SERCON bus, it loads a 
--					 32-bit TLU data and wait to be read by the SERCON bus, then load a new one
--						This module need to have the same clock as the TLU_FSM
--						
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;



entity TLU_output_latch is

  port(
	-- system inputs
	 rst : in std_logic;
    clk_in: in std_logic; 
	 debug: out std_logic_vector(3 downto 0);	 
	 
    --Inputs TLU FSM interface
	 TLU_Data_in: in std_logic_vector(31 downto 0);		
	 fifo_rd_out: out std_logic;
	 fifo_empty: in std_logic;
	 fifo_busy: in std_logic;
	 
	 -- SERCON interface 
	 TLU_Data_out: out std_logic_vector(31 downto 0);		
	 sercon_load: in std_logic 
	 
	 	 
	 );
  
  
end entity TLU_output_latch;

-- generate slow clock
architecture v0 of TLU_output_latch is


   
	type status_type is ( sInt, sChkBuf, sLoadBuf, sReady ,sSERCONAct);
	signal CS : status_type;
	
	signal int_TLUData: std_logic_vector (31 downto 0);
	signal int_fifo_rd: std_logic;
	signal int_debug: std_logic_vector (3 downto 0);

	begin
	
	TLU_Data_out <= int_TLUData;
	fifo_rd_out	<=	int_fifo_rd;
	debug <= int_debug;
		
FSM: process (rst, clk_in, sercon_load) 
	begin
		if (rst = '1')  then
			CS <= sInt;	
							
        elsif (clk_in'event and clk_in = '1') then
			
       	case CS is 
       	
			
				--------- Initialisation--------------
				when sInt =>
						int_TLUData <= x"00000000";
						int_fifo_rd <= '0';

						int_debug <= "1111";
						
						CS <= sChkBuf; 
	  	  
				when sChkBuf => -- ready to recieve trigger
							int_debug <= "1110";			
						
						if fifo_busy = '1' then
							int_TLUData <= x"00000000";
							int_fifo_rd <= '0';
								
							CS <= sChkBuf;
								
						elsif	fifo_empty = '1' then
								int_TLUData <= x"00000000";
								int_fifo_rd <= '0';
								
								CS <= sChkBuf;
							
						else
								int_TLUData <= x"00000000";
								int_fifo_rd <= '1';
								CS <= sLoadBuf;
							
						end if;
						
						
				when sLoadBuf =>
						int_TLUData <= TLU_Data_in;
						int_fifo_rd <= '0';
						int_debug <= "1100";
						
						CS <= sReady;


				when sReady => -- incoming trigger, reply with "busy"
						int_TLUData <= int_TLUData;
						int_fifo_rd <= '0';
						int_debug <= "1101";
						if sercon_load = '0' then
							CS <= sReady;
							
						else
							CS <= sSERCONAct;
							
						end if;
					
					
					When sSERCONAct =>
						int_TLUData <= int_TLUData;
						int_fifo_rd <= '0';
						int_debug <= "1011";


						if sercon_load = '1' then

							CS <= sSERCONAct;
							
						else 
							-- may need delay here
							CS <= sChkBuf;
							
						end if;
						
		
						
				when others =>
						int_TLUData <= int_TLUData;
						int_fifo_rd <= '0';
							
						CS <= sInt;
				
			end case;
		
	end if;	
	
end process;

end architecture v0;

