-- LED driver
-- Low active LEDs (0 = On)

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;

USE work.sercon_types.all;

entity led_driver is

  generic(
    FLASH_DIVDER:natural:=32
    );
    
  port(
	 rst : in std_logic;
    clk_in: in std_logic;
    --
    usb_act: in std_logic;
    LED0: out std_logic;  --D4
		led1: out std_logic --D5
    );
  
  
end entity led_driver;

--
architecture v0 of led_driver is

 
  signal COUNTER: std_logic_vector(FLASH_DIVDER-1 downto 0);


  begin
  
led: process (clk_in, rst, usb_act) 
	begin
    if(rst='0')then -- low active push switch on reset

      COUNTER<=(others=>'0');
		led0 <= '1';
		led1 <= '1';

    elsif(clk_in='1' and clk_in'event)then 
		counter <= counter + 1;
		
      if usb_act = '0' then -- led flash on low active signal, whicn is read AND write (both low active)
			led0 <= counter (FLASH_DIVDER-1);
			led1 <= '1';
		else
			led0 <= '1';
			led1 <= '1';
		end if;


	end if;

 end process led;     

 
  
end architecture v0;

