LIBRARY ieee;
USE ieee.std_logic_1164.all;
PACKAGE sercon_types IS

  constant sercon_bit_width: natural:=32;
    
  type sercon_ctrl is
    record
      rst: std_logic;
      clk: std_logic;
      cen:std_logic;
      wload: std_logic;
      rload: std_logic;
    end record; 
      
  type sercon_bus is
    record
      smask:std_logic;
      sdata: std_logic;
    end record;

  type sercon_bus_array is array (natural range <>) of
    sercon_bus;
  
  type long_word_array is array (natural range <>) of
    std_logic_vector(sercon_bit_width-1 downto 0);
  
END sercon_types;
