library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity slave_clk_driver is

  port(
    rst: in std_logic;
    clk: in std_logic;
    clkb: in std_logic;
    --
    clk_out: out std_logic
   );

end entity slave_clk_driver;

architecture v0 of slave_clk_driver is

  component fddrrse
  generic(
    INIT : bit := '0'
    );
  port(
    Q : out std_ulogic;

    C0 : in std_ulogic;
    C1 : in std_ulogic;
    CE : in std_ulogic;
    D0 : in std_ulogic;
    D1 : in std_ulogic;
    R  : in std_ulogic;
    S  : in std_ulogic
    );
  end component fddrrse;

  constant int_high:std_logic:='1';
  constant int_low:std_logic:='0';

begin

  u_ddr_output:fddrrse
    generic map(INIT=>'0')
    port map(
      q=>clk_out,
      --
      c0=>clk,
      c1=>clkb, 
      ce=>int_high,
      d0=>int_low,
      d1=>int_high,
      r=>rst,
      s=>int_low
      );

  
  
end architecture v0;
