----------------------------------------------------------------------------------
-- Company: University of Oxford
-- Engineer: Rui Gao
-- 
-- Create Date:    15:02:17 01/25/2010 
-- Design Name: 
-- Module Name:    TLU_FSM - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: This module performce a trigger number handshake with the EUDET TLU
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;

USE work.sercon_types.all;

entity TLU_FSM is

  generic(
    bit_width:natural:=32
    );
    
  port(
	 rst : in std_logic;
    clk_in: in std_logic; 
	 debug: out std_logic_vector(3 downto 0);
    
	 TLU_trigger_in: in std_logic;
	 TLU_rst_in: in std_logic;
        	 
	 TrigNum_out: out std_logic_vector(bit_width -1 downto 0);		
	 TrigNum_Ready_Out: out std_logic;	 
	 TLU_busy_out: out std_logic;
	 TLU_tirg_clk_out: out std_logic -- output clock need to be in 10 - 20Mhz range
	 );
  
  
end entity TLU_FSM;

-- generate slow clock
architecture v0 of TLU_FSM is


   
	type status_type is ( sInt, sReady ,sReturn, sTrigIn, sTirgNumber, sTrigComplete);
	signal CS : status_type;
	
	signal TLU_busy : std_logic;
	signal TLU_tirg_clk: std_logic;

	signal Counter: std_logic_vector(4 downto 0); 
   signal trignumber: std_logic_vector (bit_width -1 downto 0);
	signal loadreg: std_logic;
	signal TrigNumberReady: std_logic;
	
	begin

		TrigNum_Ready_Out <= TrigNumberReady;
		TLU_busy_out <= TLU_busy;
	--	debug (3) <= TLU_busy;
   --	debug (2) <= counter(4);
		debug (1) <= TLU_busy;
		debug (0) <= TLU_trigger_in;

handshake: process (rst, clk_in, TLU_trigger_in ) 
	begin
		if (rst = '0')  then
			CS <= sInt;	
			
			debug (3 downto 2) <= "11";
	 						
        elsif (clk_in'event and clk_in = '1') then
			
			
       	case CS is 
       	
			
				--------- Initialisation--------------
				when sInt =>
				
						TLU_busy <= '0';
						TLU_tirg_clk <= '0';
						trignumber<= (others =>'0');
						
						counter <= "00000";
						TrigNumberReady <= '0';
						debug (3 downto 2) <="10";

						CS <= sReady; 
	  	  
				when sReady => -- ready to recieve trigger
						trignumber<= trignumber;
						counter <= counter;
						TrigNumberReady <= '0';
						
				
						if TLU_trigger_in = '1' then
							TLU_busy <= '1';
							TLU_tirg_clk <= '0'; -- check again
							debug (3 downto 2) <="11";
							
							CS <= sTrigIn;
							
						else
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							debug (3 downto 2) <="10";
							CS <= sReady;
							
						end if;

				when sTrigIn => -- incoming trigger, reply with "busy"
								
							TLU_busy <= '1';
							TLU_tirg_clk <= '1';
							trignumber<= trignumber;
							loadreg <= '0';
							counter <= counter + 1;
							-- !!may need some delay here!!
							TrigNumberReady <= '0';
							debug (3 downto 2) <="01";
							
							CS <= sTirgNumber; 
				 

				when sTirgNumber => -- recieve serial trigger number
						
						TrigNumberReady <= '0';
						debug (3 downto 2) <="00";
						
						if counter = "11111" then
							TLU_busy <= '0';
							TLU_tirg_clk <= '0';
							trignumber <= trignumber;
							counter <= counter;

							CS <= sTrigComplete;
							
						else  -- stop recieving trigger number
							TLU_busy <= '1';
							TLU_tirg_clk <= clk_in;
							trignumber <= trignumber (bit_width - 2 downto 0) & TLU_trigger_in;
							TLU_tirg_clk <= '1';
							counter <= counter + 1;
							
														
							CS <= sTirgNumber;
							
						end if;	
						

				when sTrigComplete => -- Tirgger Handshake complete, flag TrigNumberReady high
				
					
							TLU_busy <= '1';
							TLU_tirg_clk <= '0';
							TrigNumberReady <= '1';
							trignumber <= trignumber;
							counter <= counter;
							debug (3 downto 2) <="00";
	
						   CS <= sReady;
						
				when others =>
					
					CS <= sReady;
				
			end case;
		
	end if;	
	
end process;

clock_mux: process (clk_in,TLU_tirg_clk )
begin
	if TLU_tirg_clk = '1' then
			TLU_tirg_clk_out <= clk_in;
	else
			TLU_tirg_clk_out <= '0';
	end if;
end process clock_mux;

			

  
end architecture v0;

