----------------------------------------------------------------------------------
-- Company: University of Oxford
-- Engineer: Rui Gao
-- 
-- Create Date:    15:02:17 01/25/2010 
-- Design Name: 
-- Module Name:    TLU_HSK - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: This module performce a trigger number handshake with the EUDET TLU
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;
USE work.sercon_types.all;

Library UNISIM;
use UNISIM.vcomponents.all;


entity TLU is

    
  port(
	 rst : in std_logic;
    clk_in: in std_logic; 
	 debug: out std_logic_vector(3 downto 0);
	 
	 TrigNum_out: out std_logic_vector(31 downto 0);		
	 TrigNum_Ready_Out: out std_logic;	
    
	 -- TLU Connections
	 TLU_trigger_in: in std_logic;
	 TLU_rst_in: in std_logic;
    TLU_busy_out: out std_logic;
	 TLU_tirg_clk_out: out std_logic -- output clock need to be in 10 - 20Mhz range
	 );
  
  
end entity TLU;

-- generate slow clock
architecture v0 of TLU is

	signal int_TLU_busy : std_logic;
	signal int_TLU_tirg_clk: std_logic;
	signal Counter: std_logic_vector (3 downto 0); --std_logic_vector(bit_width/8 +1 downto 0); 
   signal int_TLU_TrigNum: std_logic_vector (15 downto 0);
	signal int_loadreg: std_logic;
	signal int_TrigNumberReady: std_logic;
	signal slow_clk: std_logic;
	



	begin
	
	--	TrigNum_out <= int_TLU_TrigNum;
		TrigNum_Ready_Out <= int_TrigNumberReady;
		TLU_busy_out <= int_TLU_busy;
--		debug <= int_TLU_TrigNum;
		
		TrigNum_out(31 downto 16) <= x"0000";
		TrigNum_out(15 downto 0) <= int_TLU_TrigNum;
	--	debug(0) <= int_TLU_busy; -- assign debug port
	--	debug(1) <= TLU_trigger_in; -- assign debug port
	--	debug(3 downto 2) <= Counter (2 downto 1); -- assign debug port
		
	--	TLU_tirg_clk_out <= counter(3); --int_TLU_tirg_clk;
		


handshake: process (rst, slow_clk, TLU_trigger_in, TLU_rst_in ) 
	begin
	--	if (rst = '1' or TLU_rst_in = '1')  then
		if (rst = '1')  then
				
			int_TLU_TrigNum  <= x"0000";
			int_TLU_busy <='0';
			int_TLU_tirg_clk <= '0';
			Counter <= "1111";
			int_loadreg <= '0';
			int_TrigNumberReady <='0';
			--debug(3 downto 2) <= "11";
			
		--	slow_clk <= slow_clk + 1;
		--	int_TrigNumberReady <= '0';	
				
			elsif (clk_in'event and clk_in = '1') then
			
					
				if int_TLU_busy = '0' then -- idle
					if TLU_trigger_in = '1' then
						-- increase counter, change busy to high start issuing trigger clock
							int_TLU_busy <= '1';
							int_TLU_TrigNum <= int_TLU_TrigNum;
							int_TLU_tirg_clk <= '1';
							int_TrigNumberReady <= int_TrigNumberReady;
							Counter <= Counter + 1;
					--		debug(3 downto 2) <= "10";
							
					else	-- idle
							int_TLU_busy <= '0';
							int_TLU_TrigNum <= int_TLU_TrigNum;
							int_TLU_tirg_clk <= '0';
							int_TrigNumberReady <= int_TrigNumberReady;
							Counter <= Counter;
					--		debug(3 downto 2) <= "01";
					
					end if;
				elsif counter = "1111" then  -- busy = '1'
						int_TLU_busy <= '0';
						int_TLU_TrigNum <= int_TLU_TrigNum;
						int_TLU_tirg_clk <= '0';
						int_TrigNumberReady <= '1';
						Counter <= Counter;
					--	debug(3 downto 2) <= "10";
					else
						int_TLU_busy <= '1';
						int_TLU_TrigNum <= TLU_trigger_in & int_TLU_TrigNum (14 downto 0);
						int_TLU_tirg_clk <= '1';
						int_TrigNumberReady <= int_TrigNumberReady;
						Counter <= Counter + 1;
					--	debug(3 downto 2) <= "11";
					
				
				end if;
	
	
	end if;	
	
end process;


--TLU_clk <= clk_delay (clk_delay_width -1);
--
--TLU_clk_delay: process (clk_in)
--begin
--	if (clk_in'event and clk_in = '1') then
--		clk_delay <= clk_delay + 1;
--	end if;
--end process;	

--TLU_tirg_clk_out <= clk_in;

clock_mux: process (clk_in,int_TLU_tirg_clk )
begin
	if int_TLU_tirg_clk = '1' then
			TLU_tirg_clk_out <= clk_in;
	else
			TLU_tirg_clk_out <= '0';
	end if;
end process clock_mux;


---- BUFGCE: Global Clock Buffer with Clock Enable (active high)
---- Virtex-II/II-Pro/4/5, Spartan-3/3E/3A
---- Xilinx HDL Libraries Guide, version 10.1.2
--BUFGCE_inst : BUFGCE
--port map (
--O => TLU_tirg_clk_out, -- Clock buffer ouptput
--CE => int_TLU_tirg_clk, -- Clock enable input
--I => clk_in -- Clock buffer input
--);
---- End of BUFGCE_inst instantiation

  
end architecture v0;

