--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
--
entity jtag_driver is
  port(
    rst: in std_logic;
    clk: in std_logic;
    --
    busy: out std_logic;
    clock_lock: in std_logic;
    --
    int_tms: in std_logic;
    int_tdi: in std_logic;
    int_tdo: out std_logic;
    --
    tck: inout std_logic;
    tms: inout std_logic;
    tdi: inout std_logic;
    tdo: in std_logic
    );
end entity jtag_driver;
--
architecture v0 of jtag_driver is

  signal int_tck:std_logic;
  signal int_clock_lock: std_logic;
  signal int_toggle: std_logic;
  signal int_count: std_logic_vector(15 downto 0);

begin
  tck<='Z' when int_tck='1' else '0';
  tms<='Z' when int_tms='0' else '0';
  tdi<='Z' when int_tdi='0' else '0';
  int_tdo<=tdo;


  busy<=int_toggle;
  
  do_clock: process(rst, clk)
  begin 
    if(rst='1')then
      int_tck<='1';
      int_count<=(others=>'0');
      int_clock_lock<='0';
      int_toggle<='0';
    elsif(clk='1' and clk'event)then
      
      int_tck<='1';
      if(int_toggle='0')then 
        if(clock_lock/=int_clock_lock)then 
          int_clock_lock<=clock_lock;
          int_toggle<='1';
        end if;
      else
        int_count<=int_count+1;
        if(int_count>50 and int_count<100)then
          int_tck<='0';
        end if;
        if(int_count>150)then
          int_toggle<='0';
          int_count<=(others=>'0');
        end if;
      end if;
      
    end if;
  end process do_clock;
    
end architecture v0;

