-- TLU trigger number input added by Rui Gao 10/02/2010



library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

use work.sercon_types.all;

entity sercon_info is
  port(
	TLU_trig_num : in std_logic_vector (31 downto 0); -- TLU trigger number input, which replaces version, RG 01/02/2010 
    ctrl: in sercon_ctrl;
    sbus_in: in sercon_bus;
    sbus_out: out sercon_bus;
	 data_out: out std_logic_vector (31 downto 0); 
	 sercon_load: out std_logic
	 
    );
end entity sercon_info;

architecture v0 of sercon_info is
  component sercon_stat 
    generic(
      bit_width:natural:=32
      );
    port(
      ctrl: in sercon_ctrl;
      --
      sbus_in: in sercon_bus;
      sbus_out: out sercon_bus;

      -- parallel data input.
      pdin: in std_logic_vector(bit_width-1 downto 0)
      );
  end component sercon_stat;
  
  component sercon_stat_TLU 
    generic(
      bit_width:natural:=32
      );
  port(
    ctrl: in sercon_ctrl;
    --
    sbus_in: in sercon_bus;
    sbus_out: out sercon_bus;
   sercon_load: out std_logic;
	 
    -- parallel data input.
    pdin: in std_logic_vector(bit_width-1 downto 0)
    );
  end component sercon_stat_TLU;

  component build_time
    port(
      build_utc_output: out std_logic_vector(31 downto 0)
      );  
  end component build_time;
  
   
  component version     
    port(
      rev_output: out std_logic_vector(31 downto 0)
      );
  end component version;
  
  signal int_bus:sercon_bus;
  signal int_utc:std_logic_vector(31 downto 0);
  signal int_version:std_logic_vector(31 downto 0);
  signal int_bus_11:sercon_bus;
  
  
begin
  u_utc_readout:sercon_stat
    generic map(
      bit_width=>32)
    port map(
      ctrl => ctrl,
      sbus_in => sbus_in,
      sbus_out => int_bus,
      pdin => int_utc
      );

  u_version_readout:sercon_stat_TLU
    generic map (bit_width => 32)
    port map (
      ctrl => ctrl,
      sbus_in => int_bus,
		sercon_load => sercon_load,
      sbus_out => int_bus_11,
      --pdin => int_version, RG
		pdin => int_version
      );
		
  u_reg11_readout:sercon_stat_TLU
    generic map (bit_width => 32)
    port map (
      ctrl => ctrl,
      sbus_in => int_bus_11,
		sercon_load => open,
      sbus_out => sbus_out,
      --pdin => int_version, RG
		pdin => TLU_trig_num
      );
		
  u_utc:build_time
    port map (build_utc_output => int_utc);

  u_version:version
    port map(rev_output => int_version);
--	port map(rev_output => int_version); -- TLU trigger number, RG
	

  
end architecture v0;
