#!/usr/bin/env python
# Submits a single visit (00741720) to the grid for processing.
# The job IDs are recorded in a file named 'visit_jobs_00741720.txt'.

import sys

from DIRAC.Core.Base import Script
Script.parseCommandLine()

from DIRAC.Interfaces.API.Job import Job
from DIRAC.Interfaces.API.Dirac import Dirac

dirac = Dirac()

visit = '00741720'
print "Submitting jobs for visit", visit

indices = []
for i in range(0, 48):
    indices.append(i)

# open a file to record a list of jobs for this visit
joblistfile = open('visit_jobs_' + visit + '.txt', 'w')

for idx in indices:
    j = Job()
    j.setName("ImSim_" + visit + "_" + str(idx));
    
    instcatname = visit + ".tar.gz"
    insidename = visit + '/phosim_cat_' + str(int(visit)) + '.txt'

    startsensor = idx * 4
    numsensors = 2
    if idx == 47:
        numsensors = 1
    
    args = visit + ' ' + insidename + ' ' + str(startsensor) + ' ' + str(numsensors) + ' ' + str(idx)
    outputname = 'fits_' + visit + '_' + str(idx) + '.tar'
    
    j.setCPUTime(1209600)
    j.setExecutable('launch_container_userns.sh', arguments=args)
    j.stderr="std.err"
    j.stdout="std.out"
    j.setInputSandbox(["launch_container_userns.sh","docker_run.sh","run_imsim_nersc.py","parsl_imsim_configs","finals2000A.all","LFN:/lsst/user/j/james.perry/instcats/2.2i/y04/" + instcatname])
    j.setOutputSandbox(["std.out","std.err"])
    #j.setTag(["4Processors"])
    #j.setOutputData([outputname], outputPath="", outputSE=["UKI-NORTHGRID-LANCS-HEP-disk"])
    j.setPlatform("EL7")

    j.setDestination("CLOUD.UK-CAM-CUMULUS-backfill.uk")
 
    jobID = dirac.submitJob(j)
    print("Submitted job as ID " + str(jobID))
    print "Status is:", dirac.status(jobID['JobID'])
    
    joblistfile.write(str(jobID['JobID']) + '\n')


joblistfile.close()
