/*
 * Author : Kirika Uchida
 */
#include <getopt.h>
#include <iostream>
#include <iomanip>
#include "CbcI2cRegIpbusInterface.h"
#include <stdlib.h>
#include <string.h>
#include <sstream>

using namespace std;
using namespace cbc3hal;

void printHelp( char *argv[] )
{
    unsigned indent(50);
    cout << setfill(' ');
    cout << "usage: " << argv[0] << "\n" 
        << setw(indent) << " --help                                            "  << ": prints this help.\n" 
        << setw(indent) << " --to_name                                         "  << ": default output is with address. This option enable output with name.\n" 
        << setw(indent) << " --to_Ph2_ACF                                      "  << ": This option enable output in Ph2_ACF format.\n" 
        << setw(indent) << "[file list separated by spaces ]                   "  << ": file list. The files listed in the left side are overwritten. But name lists are processed after the all configurations with page and address.\n" 
        << endl;
}
int main( int argc, char *argv[] )
{
    bool to_name(false);
    bool to_Ph2_ACF(false);
    //getting options
    int c;
    while(1)
    {
        static struct option long_options[] = { 
            { "help"       , no_argument, 0, 'a' },
            { "to_name"    , no_argument, 0, 'b' },
            { "to_Ph2_ACF" , no_argument, 0, 'c' },
        };
        int option_index = 0;
        c = getopt_long( argc, argv, "ab", long_options, &option_index );
        if( c == -1 ) {
            break;
        }
        switch( c )
        {
            case 'a':
                printHelp( argv );
                return 0;
            case 'b':
                to_name = true;
                break;
            case 'c':
                to_Ph2_ACF = true;
                break;
            default:
                abort();
        }
    }
    std::vector<string> files;
    while( optind < argc ){
        files.push_back( argv[optind++] );
        //cout << "file " << ++i << " : " << files.back() << endl; 
    }
    if( to_name ){
        if(files.size() == 1) print_name_regcnf(files.at(0), cout);
        else print_name_regcnf( files, cout );
    }
    else{
        if( to_Ph2_ACF ){
            ofstream otmpf( "tmp.txt" );
            print_regcnf( files, otmpf ); 
            otmpf.close();
            ifstream itmpf( "tmp.txt" );
            char line[256];
            map<unsigned,string> page1;
            map<unsigned,string> page2;
            if( itmpf.is_open() ){
                while( !itmpf.eof() ){
                    itmpf.getline( line, 256 );
                    if( strlen(line) == 0 || line[0] == '#' || line[0] == ' ' ){
                        continue;
                    }
                    istringstream iss( line );
                    string page, addr_str, value;
                    unsigned addr(0);
                    iss >> page >> addr_str >> value;
                    addr = strtol( addr_str.c_str(), 0, 0 );
                    if(page == "1") page1[addr]=value;
                    if(page == "2") page2[addr]=value;
                }
            }
	    system("rm tmp.txt");
            ifstream ph2_acf_f( "CBC3_default.txt" );
            if( ph2_acf_f.is_open() ){
                while( !ph2_acf_f.eof() ){
                    ph2_acf_f.getline( line, 256 );
                    if( strlen(line ) == 0 || line[0] == '*' || line[0] == ' ' ){
                        cout << line << endl;
                    }
                    else{
                        istringstream iss( line );
                        string name, page, addr_str, defval, val;
                        unsigned addr(0);
                        iss >> name >> page >> addr_str >> defval;
                        addr = strtol( addr_str.c_str(), 0, 0 );
                        if( page == "0x00") val = page1[addr];
                        else val = page2[addr];
                        cout << line << "    " << val << endl;
            //            cout << val << endl;
                    }
                }
            } 
        }
        else
            print_regcnf( files, cout );

    }
}
