#include <iostream>
#include "Tutorial/Exercise/interface/ParentAnalyser.h"

using std::cout;
using std::endl;

ParentAnalyser::ParentAnalyser(const edm::ParameterSet& cfg) {

  edm::Service<TFileService> fs;
  hMass = fs->make<TH1F>("hMass", "#mu-#mu opposite-sign mass;Mass/GeV/Events/1GeV", 240, 0, 12);

}

ParentAnalyser::~ParentAnalyser() {
 


}

void ParentAnalyser::analyze(const edm::Event& event, const edm::EventSetup& setup) {
  // getthe particles made previously
  edm::Handle<std::vector<reco::LeafCandidate> > parentHandle;
  event.getByLabel("parentProducer", parentHandle);
  // std::cout << "parentHandle->size(): " << parentHandle->size() << std::endl;
  for (std::vector<reco::LeafCandidate>::const_iterator it = 
	 parentHandle->begin(); it != parentHandle->end(); it++) {
    //    cout << "Mass: " << (*it).p4().M() << endl;
    hMass->Fill((*it).p4().M());
  }


}

DEFINE_FWK_MODULE(ParentAnalyser);

