import FWCore.ParameterSet.Config as cms
process = cms.Process("Exercise")


process.TFileService = cms.Service("TFileService", 
                                   fileName = cms.string("exercise.root"))


process.maxEvents = cms.untracked.PSet(
         input = cms.untracked.int32(5000)
)

#process.source = cms.Source("PoolSource",
#    fileNames = cms.untracked.vstring(
#        '/store/data/Run2010B/Mu/RECO/Nov4ReReco_v1/0001/F447BC06-38EC-DF11-ACB#D-485B39800B8A.root'
#   )
#)

#process.source = cms.Source("PoolSource",
#     fileNames = cms.untracked.vstring(
#    '/store/data/Run2012A/DoubleMu/AOD/PromptReco-v1/000/190/450/ACAEB147-ED80-E111-A73F-0025901D6268.root'
#              )
#)

#process.source = cms.Source("PoolSource",
#     fileNames = cms.untracked.vstring(
#    'store/data/Run2011A/DoubleMu/AOD/PromptReco-v6/000/172/999/02625EC2-96C5-E011-89C6-003048F1C420.root'
#    )
#)

process.source = cms.Source("PoolSource", fileNames = cms.untracked.vstring(
'root://gfe02.grid.hep.ph.ic.ac.uk:1097/store/data/Run2011A/DoubleMu/AOD/PromptReco-v6/000/172/999/02625EC2-96C5-E011-89C6-003048F1C420.root',
'root://gfe02.grid.hep.ph.ic.ac.uk:1097/store/data/Run2011A/DoubleMu/AOD/PromptReco-v6/000/172/999/5CE43F0F-5FC5-E011-9D6D-003048D2C108.root',
'root://gfe02.grid.hep.ph.ic.ac.uk:1097/store/data/Run2011A/DoubleMu/AOD/PromptReco-v6/000/172/999/68644937-6AC5-E011-A671-003048F117EC.root',
'root://gfe02.grid.hep.ph.ic.ac.uk:1097/store/data/Run2011A/DoubleMu/AOD/PromptReco-v6/000/172/999/92502338-6AC5-E011-8651-BCAEC532972B.root',
'root://gfe02.grid.hep.ph.ic.ac.uk:1097/store/data/Run2011A/DoubleMu/AOD/PromptReco-v6/000/172/999/E2BA9F8E-6EC5-E011-9BA3-003048F11114.root',
'root://gfe02.grid.hep.ph.ic.ac.uk:1097/store/data/Run2011A/DoubleMu/AOD/PromptReco-v6/000/172/998/1CF9A2B4-4FC5-E011-BD4C-BCAEC532971B.root',
'root://gfe02.grid.hep.ph.ic.ac.uk:1097/store/data/Run2011A/DoubleMu/AOD/PromptReco-v6/000/172/998/8C539EAF-2AC5-E011-92FE-BCAEC53296F4.root'
) )

process.load("DPGAnalysis.Skims.goodvertexSkim_cff")
process.load("Tutorial.Exercise.parentProducer_cff")

process.twoMuonFilter = cms.EDFilter("TwoMuonFilter")
#process.parentProducer = cms.EDProducer("ParentProducer")
process.parentAnalyser = cms.EDAnalyzer("ParentAnalyser")

process.p = cms.Path(process.goodvertexSkim+process.twoMuonFilter+process.parentProducer+process.parentAnalyser)


