#include "Tutorial/Exercise/interface/TwoMuonFilter.h"

// framework includes
#include "DataFormats/MuonReco/interface/Muon.h"
// this defines the muon collection
#include "DataFormats/MuonReco/interface/MuonFwd.h"


TwoMuonFilter::TwoMuonFilter(const edm::ParameterSet& cfg) {}

TwoMuonFilter::~TwoMuonFilter() {}

bool TwoMuonFilter::filter(edm::Event& event, const edm::EventSetup& setup) {

  edm::Handle<reco::MuonCollection> muon_handle;
  event.getByLabel("muons",muon_handle);
  // reco::MuonCollection::const_iterator muon;
  std::cout << muon_handle->size() << std::endl; 
  
  if (muon_handle->size() > 1) {
    return true;
  }
  return false;
}

DEFINE_FWK_MODULE(TwoMuonFilter);
